% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{enrichmentResults}
\alias{enrichmentResults}
\title{Access the results of functional enrichment analyses}
\usage{
enrichmentResults(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}
}
\value{
A \code{data.frame} object containing the results of functional enrichment
analyses, as returned by the \code{\link[=enrichGenes]{enrichGenes()}} function.
}
\description{
This function accesses the \code{data} slot of a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} object and returns
a \code{data.frame} with enrichment results.
}
\examples{
# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

# extract results
de_df <- enrichmentResults(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
