% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{Available-classifiers}
\alias{Available-classifiers}
\alias{availableMethods}
\alias{printAvailableMethods}
\title{Available classification/regression methods in \code{MLSeq}}
\usage{
availableMethods(model = NULL, regex = TRUE, ...)

printAvailableMethods()
}
\arguments{
\item{model}{a character string indicating the name of classification model. If NULL, all the available methods from \code{MLSeq}
is returned. Otherwise, the methods which are complete or partial matches to requested string is returned. See \code{regex} for
details.}

\item{regex}{a logical: should a regular expressions be used? If FALSE, a simple match is conducted against the whole name of the model.}

\item{\dots}{options to pass to \code{\link[base:grep]{grepl}}.}
}
\value{
a requested or complete character vector of available methods.
}
\description{
This function returns a character vector of available classification/regression methods in \code{MLSeq}. These methods
are imported from \code{caret} package. See details below.
}
\details{
There are 200+ methods available in \code{caret}. We import approximately 85 methods which are available for "classification" task.
Some of these methods are available for both classification and regression tasks. \code{availableMethods()} returns a character vector
of available methods in \code{MLSeq}. These names are directly used in \code{\link{classify}} function with arguement \code{method}.
See \url{http://topepo.github.io/caret/available-models.html} for a complete list of available methods in \code{caret}.
Run \code{printAvailableMethods()} to print detailed information about classification methods (prints to R Console).
}
\note{
Available methods in \code{MLSeq} will be regularly updated. Some of the methods might be removed as well as some others
took its place in \code{MLSeq}. Please check the available methods before fitting the model. This function is inspired
from the function \code{getModelInfo()} in \code{caret} and some of the code chunks and help texts are used here.
}
\seealso{
\code{\link{classify}}, \code{\link[caret:modelLookup]{getModelInfo}}, \code{\link[caret]{train}}
}
