% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/methods.R
\docType{methods}
\name{confusionMat}
\alias{confusionMat}
\alias{confusionMat,MLSeq-method}
\alias{confusionMat,MLSeqModelInfo-method}
\title{Accessors for the 'confusionMat' slot.}
\usage{
confusionMat(object)

\S4method{confusionMat}{MLSeq}(object)

\S4method{confusionMat}{MLSeqModelInfo}(object)
}
\arguments{
\item{object}{an \code{MLSeq} or \code{MLSeqModelInfo} object.}
}
\description{
This slot stores the confusion matrix for the trained model using \code{classify} function.
}
\details{
\code{confusionMat} slot includes information about cross-tabulation of observed and predicted classes
and corresponding statistics such as accuracy rate, sensitivity, specifity, etc. The returned object
is in \code{confusionMatrix} class of caret package. See \code{\link[caret]{confusionMatrix}} for details.
}
\examples{
\dontrun{
library(DESeq2)
data(cervical)

# a subset of cervical data with first 150 features.
data <- cervical[c(1:150), ]

# defining sample classes.
class <- data.frame(condition = factor(rep(c("N","T"), c(29, 29))))

n <- ncol(data)  # number of samples
p <- nrow(data)  # number of features

# number of samples for test set (30\% test, 70\% train).
nTest <- ceiling(n*0.3)
ind <- sample(n, nTest, FALSE)

# train set
data.train <- data[ ,-ind]
data.train <- as.matrix(data.train + 1)
classtr <- data.frame(condition = class[-ind, ])

# train set in S4 class
data.trainS4 <- DESeqDataSetFromMatrix(countData = data.train,
                   colData = classtr, formula(~ 1))

## Number of repeats (repeats) might change model accuracies ##
# Classification and Regression Tree (CART) Classification
cart <- classify(data = data.trainS4, method = "rpart",
          ref = "T", preProcessing = "deseq-vst",
          control = trainControl(method = "repeatedcv", number = 5,
                                 repeats = 3, classProbs = TRUE))

confusionMat(cart)
}

}
\seealso{
\code{\link[caret]{confusionMatrix}}
}
