% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/methods.R
\docType{methods}
\name{ref}
\alias{ref}
\alias{ref<-}
\alias{ref,MLSeq-method}
\alias{ref,MLSeqModelInfo-method}
\alias{ref<-,MLSeq,character-method}
\title{Accessors for the 'ref' slot.}
\usage{
ref(object)

ref(object) <- value

\S4method{ref}{MLSeq}(object)

\S4method{ref}{MLSeqModelInfo}(object)

\S4method{ref}{MLSeq,character}(object) <- value
}
\arguments{
\item{object}{an \code{MLSeq} or \code{MLSeqModelInfo} object.}

\item{value}{a character string. Select reference category for class labels.}
}
\description{
This slot stores the information about reference category. Confusion matrix and related statistics are calculated using
the user-defined reference category.
}
\examples{
\dontrun{
library(DESeq2)
data(cervical)

# a subset of cervical data with first 150 features.
data <- cervical[c(1:150), ]

# defining sample classes.
class <- data.frame(condition = factor(rep(c("N","T"), c(29, 29))))

n <- ncol(data)  # number of samples
p <- nrow(data)  # number of features

# number of samples for test set (30\% test, 70\% train).
nTest <- ceiling(n*0.3)
ind <- sample(n, nTest, FALSE)

# train set
data.train <- data[ ,-ind]
data.train <- as.matrix(data.train + 1)
classtr <- data.frame(condition = class[-ind, ])

# train set in S4 class
data.trainS4 <- DESeqDataSetFromMatrix(countData = data.train,
                   colData = classtr, formula(~ 1))

## Number of repeats (repeats) might change model accuracies ##
# Classification and Regression Tree (CART) Classification
cart <- classify(data = data.trainS4, method = "rpart",
          ref = "T", preProcessing = "deseq-vst",
          control = trainControl(method = "repeatedcv", number = 5,
                                 repeats = 3, classProbs = TRUE))

ref(cart)
}

}
