% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOGAMUN.R
\name{mogamun_init}
\alias{mogamun_init}
\title{mogamun_init}
\usage{
mogamun_init(
    Generations = 500,
    PopSize = 100,
    MinSize = 15,
    MaxSize = 50,
    CrossoverRate = 0.8,
    MutationRate = 0.1,
    JaccardSimilarityThreshold = 30,
    TournamentSize = 2,
    Measure = "FDR",
    ThresholdDEG = 0.05,
    MaxNumberOfAttempts = 3
)
}
\arguments{
\item{Generations}{number of generations to run (default = 500)}

\item{PopSize}{number of subnetworks in the population (default = 100)}

\item{MinSize}{minimum size (no. of nodes) of the subnetworks (default = 15)}

\item{MaxSize}{maximum size (no. of nodes) of the subnetworks (default = 50)}

\item{CrossoverRate}{rate for the crossover (default = 0.8)}

\item{MutationRate}{rate for the mutation (default = 0.1)}

\item{JaccardSimilarityThreshold}{subnetworks over this Jaccard similarity 
threshold are considered as duplicated (default = 30)}

\item{TournamentSize}{size of the tournament (default = 2)}

\item{Measure}{measure to calculate the nodes scores and to determine which 
genes are differentially expressed 
(possible values PValue and FDR, default = FDR)}

\item{ThresholdDEG}{threshold to consider a gene as significantly 
differerentially expressed. Note: if there is a logFC available, it is also 
considered |logFC|>1  (default = 0.05)}

\item{MaxNumberOfAttempts}{maximum number of attempts to find compatible 
parents (default = 3)}
}
\value{
EvolutionParameters
}
\description{
initialize evolution parameters
}
\examples{
EvolutionParameters <- 
    mogamun_init(
        Generations = 1,
        PopSize = 10,
        MinSize = 15,
        MaxSize = 50,
        CrossoverRate = 0.8,
        MutationRate = 0.1,
        JaccardSimilarityThreshold = 30,
        TournamentSize = 2,
        Measure = "FDR",
        ThresholdDEG = 0.05,
        MaxNumberOfAttempts = 3
    )

}
