% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCodons.R
\name{compareCodons}
\alias{compareCodons}
\title{compareCodons}
\usage{
compareCodons(codA, codB)
}
\arguments{
\item{codA}{\code{codon} A [mandatory]}

\item{codB}{\code{codon} B [mandatory]}
}
\value{
vector of syn and non-syn sites
}
\description{
This function compares two codons and returns the number of syn
and non-syn sites according to \emph{Nei and Gojobori (1986)}.
}
\examples{
compareCodons("AAA","TTA")
compareCodons("AAA","TAT")
compareCodons("AAA","ATT")
compareCodons("AAA","TTT")
## load example sequence data
data("hiv", package="MSA2dist")
compareCodons(dnastring2codonmat(hiv)[1,1], dnastring2codonmat(hiv)[1,2])
}
\references{
Nei and Gojobori. (1986) Simple methods for estimating the
numbers of synonymous and nonsynonymous nucleotide substitutions.
\emph{Mol. Biol. Evol.}, \bold{3(5)}, 418-426.

Ganeshan et al. (1997) Human immunodeficiency virus type 1
genetic evolution in children with different rates of development of disease.
\emph{J. Virology.} \bold{71(1)}, 663-677.

Yang et al. (2000) Codon-substitution models for heterogeneous
selection pressure at amino acid sites. \emph{Genetics.}
\bold{155(1)}, 431-449.
}
\seealso{
\code{\link[seqinr]{kaks}}
}
\author{
Kristian K Ullrich
}
