% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionused.R
\name{regionused}
\alias{regionused}
\title{regionused}
\usage{
regionused(seq)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}
}
\value{
population names from \code{metadata}
}
\description{
This function shows the region used slot from a
\code{DNAStringSet} or an \code{AAStringSet}
\code{metadata} information.\cr
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
## create mask
mask1 <- IRanges::IRanges(start=c(11,41,71), end=c(20,50,80))
## use mask
hiv.region <- hiv |> cds2aa() |> string2region(mask=mask1)
#(hiv.region |> slot("metadata"))$regionUsed
hiv.region |> regionused()
}
\seealso{
\code{\link[MSA2dist]{addpop2string}}
}
\author{
Kristian K Ullrich
}
