% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averageMSnSet.R
\name{averageMSnSet}
\alias{averageMSnSet}
\title{Generate an average \code{MSnSet}}
\usage{
averageMSnSet(x, avg = function(x) mean(x, na.rm = TRUE), disp = npcv)
}
\arguments{
\item{x}{A \code{list} of valid \code{MSnSet} instances to be averaged.}

\item{avg}{The averaging function. Default is the mean after
removing missing values, as computed by \code{function(x)
mean(x, na.rm = TRUE)}.}

\item{disp}{The disperion function. Default is an non-parametric
coefficient of variation that replaces the standard deviation by
the median absolute deviation as computed by
\code{mad(x)/abs(mean(x))}. See \code{\link{npcv}} for
details. Note that the \code{mad} of a single value is 0 (as
opposed to \code{NA} for the standard deviation, see example
below).}
}
\value{
A new average \code{MSnSet}.
}
\description{
Given a list of \code{MSnSet} instances, typically representing
replicated experiments, the function returns an average
\code{MSnSet}.
}
\details{
This function is aimed at facilitating the visualisation of
replicated experiments and should not be used as a replacement for
a statistical analysis.

The samples of the instances to be averaged must be identical but
can be in a different order (they will be reordered by
default). The features names of the result will correspond to the
union of the feature names of the input \code{MSnSet}
instances. Each average value will be computed by the \code{avg}
function and the dispersion of the replicated measurements will be
estimated by the \code{disp} function. These dispersions will be
stored as a \code{data.frame} in the feature metadata that can be
accessed with \code{fData(.)$disp}. Similarly, the number of
missing values that were present when average (and dispersion)
were computed are available in \code{fData(.)$disp}.

Currently, the feature metadata of the returned object corresponds
the the feature metadata of the first object in the list
(augmented with the missing value and dispersion values); the
metadata of the features that were missing in this first input are
missing (i.e. populated with \code{NA}s). This may change in the
future.
}
\examples{
library("pRolocdata")
## 3 replicates from Tan et al. 2009
data(tan2009r1)
data(tan2009r2)
data(tan2009r3)
x <- MSnSetList(list(tan2009r1, tan2009r2, tan2009r3))
avg <- averageMSnSet(x)
dim(avg)
head(exprs(avg))
head(fData(avg)$nNA)
head(fData(avg)$disp)
## using the standard deviation as measure of dispersion
avg2 <-averageMSnSet(x, disp = sd)
head(fData(avg2)$disp)
## keep only complete observations, i.e proteins 
## that had 0 missing values for all samples
sel <- apply(fData(avg)$nNA, 1 , function(x) all(x == 0))
avg <- avg[sel, ]
disp <- rowMax(fData(avg)$disp)
library("pRoloc")
setStockcol(paste0(getStockcol(), "AA"))
plot2D(avg, cex = 7.7 * disp)
title(main = paste("Dispersion: non-parametric CV",
                   paste(round(range(disp), 3), collapse = " - ")))
}
\seealso{
\code{\link{compfnames}} to compare MSnSet feature names.
}
\author{
Laurent Gatto
}
