% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-mzR.R
\name{as}
\alias{as}
\alias{as.data.frame.mzRident}
\title{Coerce identification data to a \code{data.frame}}
\arguments{
\item{from}{An object of class \code{mzRident} defined in the
\code{mzR} package.}
}
\value{
A \code{data.frame}
}
\description{
A function to convert the identification data contained in an
\code{mzRident} object to a \code{data.frame}. Each row represents
a scan, which can however be repeated several times if the PSM
matches multiple proteins and/or contains two or more
modifications. To reduce the \code{data.frame} so that rows/scans
are unique and use semicolon-separated values to combine
information pertaining a scan, use
\code{\link[=reduce,data.frame-method]{reduce}}.
}
\details{
See also the \emph{Tandem MS identification data} section in the
\emph{MSnbase-demo} vignette.
}
\examples{
## find path to a mzIdentML file
identFile <- dir(system.file(package = "MSnbase", dir = "extdata"),
                 full.name = TRUE, pattern = "dummyiTRAQ.mzid")
library("mzR")
x <- openIDfile(identFile)
x
as(x, "data.frame")
}
\author{
Laurent Gatto
}
