% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-MSnSet.R
\name{nQuants}
\alias{nQuants}
\title{Count the number of quantitfied features.}
\usage{
nQuants(x, groupBy)
}
\arguments{
\item{x}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{groupBy}{An object of class \code{factor} defining how to
summerise the features. (Note that this parameter was
previously named \code{fcol} and referred to a feature
variable label. This has been updated in version 1.19.12 for
consistency with other functions.)}
}
\value{
A \code{matrix} of dimensions
\code{length(levels(groupBy))} by \code{ncol(x)}

A \code{matrix} of dimensions
\code{length(levels(factor(fData(object)[, fcol])))} by
\code{ncol(object)} of integers.
}
\description{
This function counts the number of quantified features, i.e
non NA quantitation values, for each group of features
for all the samples in an \code{"\linkS4class{MSnSet}"} object.
The group of features are defined by a feature variable names, i.e
the name of a column of \code{fData(object)}.
}
\details{
This function is typically used after \code{\link{topN}} and before
\code{\link{combineFeatures}}, when the summerising function is
\code{sum}, or any function that does not normalise to the number of
features aggregated. In the former case, sums of features might
be the result of 0 (if no feature was quantified) to \code{n}
(if all \code{topN}'s \code{n} features were quantified) features,
and one might want to rescale the sums based on the number of
non-NA features effectively summed.
}
\examples{
data(msnset)
n <- 2
msnset <- topN(msnset, groupBy = fData(msnset)$ProteinAccession, n)
m <- nQuants(msnset, groupBy = fData(msnset)$ProteinAccession)
msnset2 <- combineFeatures(msnset,
                           groupBy = fData(msnset)$ProteinAccession,
                           method = sum)
stopifnot(dim(n) == dim(msnset2))
head(exprs(msnset2))
head(exprs(msnset2) * (n/m))
}
\author{
Laurent Gatto \href{mailto:lg390@cam.ac.uk}{lg390@cam.ac.uk}, Sebastian Gibb
\href{mailto:mail@sebastiangibb.de}{mail@sebastiangibb.de}
}
