% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NTR.R
\name{normToReference}
\alias{normToReference}
\alias{NTR}
\title{Combine peptides into proteins.}
\usage{
normToReference(
  x,
  group,
  reference = .referenceFractionValues(x = x, group = group)
)
}
\arguments{
\item{x}{\code{matrix}, \code{\link{exprs}} matrix of an
\linkS4class{MSnSet} object.}

\item{group}{\code{double} or \code{factor}, grouping variable,
i.e. protein accession; has to be of length equal \code{nrow(x)}.}

\item{reference}{\code{double}, vector of reference values, has to be of the
same length as \code{group} and \code{nrow(x)}.}
}
\value{
a matrix with one row per protein.
}
\description{
This function combines peptides into their proteins by normalising the
intensity values to a reference run/sample for each protein.
}
\details{
This function is not intented to be used directly (that's why it is not
exported via \code{NAMESPACE}). Instead the user should use
\code{\link[MSnbase]{combineFeatures}}.

The algorithm is described in Nikolovski et al., briefly it works as
follows:

\enumerate{
\item Find reference run (column) for each protein (grouped rows).
We use the run (column) with the lowest number of \code{NA}.
If multiple candidates are available we use the one with the highest
intensity. This step is skipped if the user use his own \code{reference}
vector.
\item For each protein (grouped rows) and each run (column):
\enumerate{
\item Find peptides (grouped rows) shared by the current run (column) and
the reference run (column).
\item Sum the shared peptides (grouped rows) for the current run (column)
and the reference run (column).
\item The ratio of the shared peptides (grouped rows) of the current run
(column) and the reference run (column) is the new intensity for the
current protein for the current run.
}
}
}
\examples{
library("MSnbase")
data(msnset)

# choose the reference run automatically
combineFeatures(msnset, groupBy=fData(msnset)$ProteinAccession)

# use a user-given reference
combineFeatures(msnset, groupBy=fData(msnset)$ProteinAccession,
 reference=rep(2, 55))

}
\references{
Nikolovski N, Shliaha PV, Gatto L, Dupree P, Lilley KS. Label-free protein
quantification for plant Golgi protein localization and abundance. Plant Physiol.
2014 Oct;166(2):1033-43. DOI: 10.1104/pp.114.245589. PubMed PMID: 25122472.
}
\seealso{
\code{\link[MSnbase]{combineFeatures}}
}
\author{
Sebastian Gibb \href{mailto:mail@sebastiangibb.de}{mail@sebastiangibb.de}, Pavel Shliaha
}
