% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWriteMzTab.R
\name{readMzTabData_v0.9}
\alias{readMzTabData_v0.9}
\title{Read an 'mzTab' file}
\usage{
readMzTabData_v0.9(file, what = c("PRT", "PEP"), verbose = isMSnbaseVerbose())
}
\arguments{
\item{file}{A \code{character} with the \code{mzTab} file to be
read in.}

\item{what}{One of \code{"PRT"} or \code{"PEP"}, defining which of
protein of peptide section should be parse. The metadata
section, when available, is always used to populate the
\code{experimentData} slot.}

\item{verbose}{Produce verbose output.}
}
\value{
An instance of class \code{MSnSet}.
}
\description{
This function can be used to create a \code{"\linkS4class{MSnSet}"}
by reading and parsing an \code{mzTab} file. The metadata section
is always used to populate the \code{MSnSet}'s \code{experimentData}
slot.
}
\examples{
testfile <- "https://raw.githubusercontent.com/HUPO-PSI/mzTab/master/legacy/jmztab-1.0/examples/mztab_itraq_example.txt"

prot <- readMzTabData_v0.9(testfile, "PRT")

prot

pep <- readMzTabData_v0.9(testfile, "PEP")

pep
}
\seealso{
\code{\link{writeMzTabData}} to save an
\code{"\linkS4class{MSnSet}"} as an \code{mzTab} file.
}
\author{
Laurent Gatto
}
