% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters_DIANNtoMSstatsFormat.R
\name{DIANNtoMSstatsFormat}
\alias{DIANNtoMSstatsFormat}
\title{Import Diann files}
\usage{
DIANNtoMSstatsFormat(
  input,
  annotation = NULL,
  global_qvalue_cutoff = 0.01,
  qvalue_cutoff = 0.01,
  pg_qvalue_cutoff = 0.01,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeOxidationMpeptides = TRUE,
  removeProtein_with1Feature = TRUE,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  MBR = TRUE,
  quantificationColumn = "FragmentQuantCorrected",
  ...
)
}
\arguments{
\item{input}{name of MSstats input report from Diann, which includes fragment-level data.
Output fragment data with --export-quant flag in DIA-NN 2.0}

\item{annotation}{name of 'annotation.txt' data which includes Condition, BioReplicate, Run.}

\item{global_qvalue_cutoff}{The qvalue cutoff for the Q.Value column, i.e.
the run-specific precursor q-value. Default is 0.01.}

\item{qvalue_cutoff}{If MBR is false, the qvalue cutoff for the Global.Q.Value
column, i.e. global precursor q-value.  If MBR is true, the qvalue cutoff for the
Lib.Q.Value column, i.e. the q-value for the library created after the first MBR pass.
Default is 0.01.}

\item{pg_qvalue_cutoff}{If MBR is false, the qvalue cutoff for the Global.PG.Q.Value
column, i.e. the global q-value for the protein group.  If MBR is true, the
qvalue cutoff for the Lib.PG.Q.Value column, i.e. the protein group q-value for
the library created after the first MBR pass. Run should be the same as filename.
Default is 0.01.}

\item{useUniquePeptide}{should unique pepties be removed}

\item{removeFewMeasurements}{should proteins with few measurements be removed}

\item{removeOxidationMpeptides}{should peptides with oxidation be removed}

\item{removeProtein_with1Feature}{should proteins with a single feature be removed}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{MBR}{True if analysis was done with match between runs}

\item{quantificationColumn}{Use 'FragmentQuantCorrected'(default) column for quantified intensities for DIANN 1.8.x.
Use 'FragmentQuantRaw' for quantified intensities for DIANN 1.9.x.
Use 'auto' for quantified intensities for DIANN 2.x where each fragment intensity is a separate column, e.g. Fr0Quantity.}

\item{...}{additional parameters to \code{data.table::fread}.}
}
\value{
data.frame in the MSstats required format.
}
\description{
Import Diann files
}
\examples{
input_file_path = system.file("tinytest/raw_data/DIANN/diann_input.tsv", 
                                package="MSstatsConvert")
annotation_file_path = system.file("tinytest/raw_data/DIANN/annotation.csv", 
                                package = "MSstatsConvert")
input = data.table::fread(input_file_path)
annot = data.table::fread(annotation_file_path)
output = DIANNtoMSstatsFormat(input, annotation = annot, MBR = FALSE, 
                                use_log_file = FALSE)
head(output)

# For DIANN 2.0, set quantificationColumn = 'auto'
input_file_path_2_0 = system.file("tinytest/raw_data/DIANN/diann_2.0.parquet", 
                                package="MSstatsConvert")
annotation_file_path_2_0 = system.file("tinytest/raw_data/DIANN/annotation_diann_2.0.csv", 
                                package = "MSstatsConvert")
input_2_0 = arrow::read_parquet(input_file_path_2_0)
annot_2_0 = data.table::fread(annotation_file_path_2_0)
output_2_0 = DIANNtoMSstatsFormat(input_2_0, annotation = annot_2_0, MBR = FALSE, 
                                use_log_file = FALSE, quantificationColumn = 'auto')
head(output_2_0)
}
\author{
Elijah Willie
}
