% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstatsConvert_core_functions.R
\name{MSstatsBalancedDesign}
\alias{MSstatsBalancedDesign}
\title{Creates balanced design by removing overlapping fractions and filling incomplete rows}
\usage{
MSstatsBalancedDesign(
  input,
  feature_columns,
  fill_incomplete = TRUE,
  handle_fractions = TRUE,
  fix_missing = NULL,
  remove_few = TRUE,
  anomaly_metrics = c()
)
}
\arguments{
\item{input}{\code{data.table} processed by the \code{MSstatsPreprocess} function}

\item{feature_columns}{str, names of columns that define spectral features}

\item{fill_incomplete}{if TRUE (default), ensures that rows with missing data
for specific features are added as NA. For example, if the y10 ion of
peptideA is measured in the "disease" samples but entirely missing for the
"healthy" samples, rows with NA values will be created for the y10 ion of
peptideA in the "healthy" group. This process increases the number of
rows to account for all possible feature-sample combinations.}

\item{handle_fractions}{if TRUE (default), overlapping fractions will be resolved}

\item{fix_missing}{str, optional. Defaults to NULL, which means no action.
If not NULL, must be one of the options: "zero_to_na" or "na_to_zero".
If "zero_to_na", Intensity values equal exactly to 0 will be converted to NA.
If "na_to_zero", missing values will be replaced by zeros.}

\item{remove_few}{lgl, if TRUE, features with one or two measurements
across runs will be removed.}

\item{anomaly_metrics}{character vector of names of columns with quality metrics}
}
\value{
data.frame of class \code{MSstatsValidated}
}
\description{
Creates balanced design by removing overlapping fractions and filling incomplete rows
}
\examples{
unbalanced_data = system.file("tinytest/raw_data/unbalanced_data.csv", 
                              package = "MSstatsConvert")
unbalanced_data = data.table::as.data.table(read.csv(unbalanced_data))
balanced = MSstatsBalancedDesign(unbalanced_data, 
                                 c("PeptideSequence", "PrecursorCharge",
                                   "FragmentIon", "ProductCharge"))
dim(balanced) # Now balanced has additional rows (with Intensity = NA)
# for runs that were not included in the unbalanced_data table

}
