% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstatsConvert_core_functions.R
\name{MSstatsImport}
\alias{MSstatsImport}
\title{Import files from signal processing tools.}
\usage{
MSstatsImport(input_files, type, tool, tool_version = NULL, ...)
}
\arguments{
\item{input_files}{list of paths to input files or \code{data.frame} objects.
Interpretation of this parameter depends on values of parameters \code{type} and \code{tool}.}

\item{type}{chr, "MSstats" or "MSstatsTMT".}

\item{tool}{chr, name of a signal processing tool that generated input files.}

\item{tool_version}{not implemented yet. In the future, this parameter will allow
handling different versions of each signal processing tools.}

\item{...}{optional additional parameters to \code{data.table::fread}.}
}
\value{
an object of class \code{MSstatsInputFiles}.
}
\description{
Import files from signal processing tools.
}
\examples{
evidence_path = system.file("tinytest/raw_data/MaxQuant/mq_ev.csv", 
                            package = "MSstatsConvert")
pg_path = system.file("tinytest/raw_data/MaxQuant/mq_pg.csv", 
                      package = "MSstatsConvert")
evidence = read.csv(evidence_path)
pg = read.csv(pg_path)
imported = MSstatsImport(list(evidence = evidence, protein_groups = pg),
                         "MSstats", "MaxQuant")
class(imported)
head(getInputFile(imported, "evidence"))

}
