% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_logging.R
\name{.logConverterOptions}
\alias{.logConverterOptions}
\title{Log information about converter options}
\usage{
.logConverterOptions(
  feature_columns,
  remove_shared_peptides,
  remove_single_feature_proteins,
  feature_cleaning,
  is_tmt = FALSE
)
}
\arguments{
\item{feature_columns}{character vector of names of columns that
define spectral features.}

\item{remove_shared_peptides}{logical, if TRUE shared peptides will be removed.}

\item{remove_single_feature_proteins}{logical, if TRUE, proteins that only have
one feature will be removed.}

\item{feature_cleaning}{named list with maximum two (for \code{MSstats} converters)
or three (for \code{MSstatsTMT} converter) elements. If \code{handle_few_measurements} is
set to "remove", feature with less than three measurements will be removed
(otherwise it should be equal to "keep"). \code{summarize_multiple_psms} is a function
that will be used to aggregate multiple feature measurements in a run. It should
return a scalar and accept an \code{na.rm} parameter. For \code{MSstatsTMT} converters,
setting \code{remove_psms_with_any_missing} will remove features which have missing
values in a run from that run.}

\item{is_tmt}{If TRUE, the dataset comes from a TMT experiment}
}
\value{
TRUE invisibly if message was logged
}
\description{
Log information about converter options
}
\keyword{internal}
