% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectronauttoMSstatsLiPFormat.R
\name{SpectronauttoMSstatsLiPFormat}
\alias{SpectronauttoMSstatsLiPFormat}
\title{Converts raw LiP MS data from Spectronaut into the format needed for
MSstatsLiP.}
\usage{
SpectronauttoMSstatsLiPFormat(
  LiP.data,
  fasta,
  Trp.data = NULL,
  annotation = NULL,
  intensity = "PeakArea",
  filter_with_Qvalue = TRUE,
  qvalue_cutoff = 0.01,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeProtein_with1Feature = FALSE,
  removeNonUniqueProteins = TRUE,
  removeModifications = TRUE,
  removeiRT = TRUE,
  summaryforMultipleRows = max,
  which.Conditions = "all",
  use_log_file = FALSE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  base = "MSstatsLiP_log_"
)
}
\arguments{
\item{LiP.data}{name of LiP Spectronaut output, which is long-format.}

\item{fasta}{A string of path to a FASTA file, used to match LiP peptides.}

\item{Trp.data}{name of TrP Spectronaut output, which is long-format.}

\item{annotation}{name of 'annotation.txt' data which includes Condition,
BioReplicate, Run. If annotation is already complete in Spectronaut, use
annotation=NULL (default). It will use the annotation information from input.}

\item{intensity}{'PeakArea'(default) uses not normalized peak area.
'NormalizedPeakArea' uses peak area normalized by Spectronaut}

\item{filter_with_Qvalue}{TRUE(default) will filter out the intensities that
have greater than qvalue_cutoff in EG.Qvalue column. Those intensities will
be replaced with zero and will be considered as censored missing values for
imputation purpose.}

\item{qvalue_cutoff}{Cutoff for EG.Qvalue. default is 0.01.}

\item{useUniquePeptide}{TRUE(default) removes peptides that are assigned for
more than one proteins. We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that
have 1 or 2 measurements across runs.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have
only 1 feature, which is the combination of peptide, precursor charge,
fragment and charge. FALSE is default.}

\item{removeNonUniqueProteins}{TRUE will remove proteins that were not
uniquely identified. IE if the protein column contains multiple proteins
seperated by ";". TRUE is default}

\item{removeModifications}{TRUE will remove peptide that contain a
modification. Modification must be indicated by "[". TRUE is default}

\item{removeiRT}{TRUE will remove proteins that contain iRT. True is default}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple
measurements for certain feature and certain run, use highest or sum of
multiple intensities.}

\item{which.Conditions}{list of conditions to format into MSstatsLiP format.
If "all" all conditions will be used. Default is "all".}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing will be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{base}{start of the file name.}
}
\value{
a \code{list} of two \code{data.frames} in MSstatsLiP format
}
\description{
Takes as as input both raw LiP and Trp outputs from Spectronaut.
}
\examples{
# Output datasets of Spectronaut
head(LiPRawData)
head(TrPRawData)

fasta_path <- system.file("extdata", "ExampleFastaFile.fasta", package="MSstatsLiP")

MSstatsLiP_data <- SpectronauttoMSstatsLiPFormat(LiPRawData,
                                                 fasta_path,
                                                 TrPRawData)
head(MSstatsLiP_data[["LiP"]])
head(MSstatsLiP_data[["TrP"]])
}
