% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstatsPTM.R
\docType{package}
\name{MSstatsPTM}
\alias{MSstatsPTM-package}
\alias{MSstatsPTM}
\title{MSstatsPTM: A package for detecting differentially abundant
post-translational modifications (PTM) in mass spectrometry-based
proteomic experiments.}
\description{
A set of tools for detecting differentially abundant PTMs and proteins in
shotgun mass spectrometry-based proteomic experiments. The package can handle
a variety of acquisition types, including label free and TMT experiments,
acquired with DDA, DIA, SRM or PRM acquisition methods. The
package includes tools to convert raw data from different spectral processing
tools, summarize feature intensities, and fit a linear mixed effects model. A
major advantage of the package is to leverage a separate global profiling run
and adjust the PTM fold change for changes in the unmodified protein, showing
the unconvoluted PTM fold change. Finally, the package includes functionality
to plot a variety of data visualizations.
}
\section{functions }{

\itemize{
\item \code{\link{FragPipetoMSstatsPTMFormat}} : Generates MSstatsPTM
required input format for TMT FragePipe outputs.
\item \code{\link{MaxQtoMSstatsPTMFormat}} : Generates MSstatsPTM required
input format for label-free and TMT MaxQuant outputs.
\item \code{\link{ProgenesistoMSstatsPTMFormat}} : Generates MSstatsPTM
required input format for label-free Progenesis outputs.
\item \code{\link{SpectronauttoMSstatsPTMFormat}} : Generates MSstatsPTM
required input format for label-free Spectronaut outputs.
\item \code{\link{SkylinetoMSstatsPTMFormat}} : Generates
MSstatsPTM required input format for Skyline outputs.
\item \code{\link{PStoMSstatsPTMFormat}} : Generates
MSstatsPTM required input format for PEAKS outputs.
\item \code{\link{PDtoMSstatsPTMFormat}} : Generates
MSstatsPTM required input format for Proteome Discoverer outputs.
\item \code{\link{dataSummarizationPTM}} : Summarizes PSM level
quantification to peptide (modification) and protein level quantification.
For use in label-free analysis
\item \code{\link{dataSummarizationPTM_TMT}} : Summarizes PSM level
quantification to peptide (modification) and protein level quantification.
For use in TMT analysis.
\item \code{\link{dataProcessPlotsPTM}} : Visualization for explanatory
data analysis. Specifically gives ability to plot Profile and Quality
Control plots.
\item \code{\link{groupComparisonPTM}} : Tests for significant changes in
PTM and protein abundance across conditions. Adjusts PTM fold change for
changes in protein abundance.
\item \code{\link{groupComparisonPlotsPTM}} : Visualization for model-based
analysis and summarization
}
}

\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/Vitek-Lab/MSstatsPTM/issues}
}

}
\author{
\strong{Maintainer}: Anthony Wu \email{wu.anthon@northeastern.edu}

Authors:
\itemize{
  \item Devon Kohler \email{kohler.d@northeastern.edu}
  \item Tsung-Heng Tsai \email{tsai.tsungheng@gmail.com}
  \item Deril Raju \email{raju.d@northeastern.edu}
  \item Ting Huang \email{thuang0703@gmail.com}
  \item Mateusz Staniak \email{mtst@mstaniak.pl}
  \item Meena Choi \email{mnchoi67@gmail.com}
  \item Olga Vitek \email{o.vitek@northeastern.edu}
}

}
\keyword{internal}
