% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_checks.R
\name{MSstatsPrepareForDataProcess}
\alias{MSstatsPrepareForDataProcess}
\title{Prepare data for processing by `dataProcess` function}
\usage{
MSstatsPrepareForDataProcess(input, log_base, fix_missing)
}
\arguments{
\item{input}{`data.table` in MSstats format}

\item{log_base}{base of the logarithm to transform intensities}

\item{fix_missing}{str, optional. Defaults to NULL, which means no action.
If not NULL, must be one of the options: "zero_to_na" or "na_to_zero".
If "zero_to_na", Intensity values equal exactly to 0 will be converted to NA.
If "na_to_zero", missing values will be replaced by zeros.}
}
\value{
data.table
}
\description{
Prepare data for processing by `dataProcess` function
}
\examples{
raw = DDARawData 
method = "TMP"
cens = "NA"
impute = TRUE
MSstatsConvert::MSstatsLogsSettings(FALSE)
input = MSstatsPrepareForDataProcess(raw, 2, NULL)
head(input)

}
