% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calFst.R
\name{calFst}
\alias{calFst}
\title{calFst}
\usage{
calFst(
  maf,
  patient.id = NULL,
  min.vaf = 0,
  min.total.depth = 2,
  use.adjVAF = FALSE,
  plot = TRUE,
  withinTumor = FALSE,
  use.circle = TRUE,
  title = NULL,
  number.cex = 8,
  number.col = "#C77960",
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{A Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. 
Default NULL, all patients are included.}

\item{min.vaf}{Specify The minimum VAF to filter variants. Default 0.}

\item{min.total.depth}{The minimum total allele depth for filtering variants. 
Default 2.}

\item{use.adjVAF}{Use adjusted VAF in analysis when adjusted VAF or CCF is available. Default FALSE.}

\item{plot}{Logical (Default: TRUE).}

\item{withinTumor}{Logical (Default: FALSE). Whether calculate between-region heterogeneity within tumors.}

\item{use.circle}{Logical (Default: TRUE). Whether use "circle" in the plot. 
as visualization method of correlation matrix}

\item{title}{The title of the plot. Default "Nei's distance"}

\item{number.cex}{The size of text shown in correlation plot. Default 8.}

\item{number.col}{The color of text shown in correlation plot. 
Default "#C77960".}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
A list contains Fst value of MRS and Hudson estimator of each sample-pair, respectively.
}
\description{
Genetic divergence between regions of subclonal sSNVs using 
the Weir and Cockerham method
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
calFst(maf)
}
\references{
Sun R, Hu Z, Sottoriva A, et al. Between-region 
genetic divergence reflects the mode and tempo of tumor evolution. 
Nat Genet. 2017;49(7):1015-1024.

Bhatia G, Patterson N, Sankararaman S, Price AL. 
Estimating and interpreting FST: the impact of rare variants. 
Genomic Res. 2013;23(9):1514-1521.
}
