% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getTreeMethod}
\alias{getTreeMethod}
\alias{getTreeMethod,phyloTree-method}
\title{getTreeMethod}
\usage{
getTreeMethod(object)

\S4method{getTreeMethod}{phyloTree}(object)
}
\arguments{
\item{object}{An object of phyloTree}
}
\value{
Tree construction method of phyloTree
}
\description{
getTreeMethod
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
phyloTree <- getPhyloTree(maf)
getTreeMethod(phyloTree$V402)
}
