% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkDf.R
\name{createLink0df}
\alias{createLink0df}
\title{Create a link matrix}
\usage{
createLink0df(similarityMatrix, sps, condition)
}
\arguments{
\item{similarityMatrix}{\code{matrix}, a similarity matrix that contains the
NDP similarity measure between all precursors in the data set}

\item{sps}{\code{Spectra} object}

\item{condition}{\code{character}, which conditions should be included?}
}
\value{
\code{createLink0df} returns a `matrix` that gives per each row
information on linked features
}
\description{
Create a link matrix which links every feature in similarity
matrix with another.
}
\details{
\code{createLink0df} creates a \code{matrix} from a similarity matrix which 
includes all connections between features in the similarity matrix, but
exclude links which have a similarity of exactly 0.
}
\examples{
data("spectra", package = "MetCirc")
data("similarityMat", package = "MetCirc")
link0df <- createLink0df(similarityMatrix = similarityMat,
    sps = sps_tissue, condition = c("SPL", "LIM", "ANT", "STY"))

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
