% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkDf.R
\name{spectraCondition}
\alias{spectraCondition}
\title{Get MS/MS spectra that are present in condition}
\usage{
spectraCondition(sps, condition)
}
\arguments{
\item{sps}{\code{Spectra} object of \code{Spectra} package}

\item{condition}{\code{character}, vector with conditions found as columns
in the metadata slot}
}
\value{
\code{list}, named \code{list} with \code{character} vector as entries that
contains the names of the MS/MS entries in \code{spectra} that are present 
in the \code{conditon} (tissues, stress conditions, time points, etc.)
}
\description{
\code{spectraCondition} returns the names of \code{Spectra} that are
present in condition, corresponding to the slot
\code{metadata}.
}
\details{
Helper function in \code{createLink0df} and \code{shinyCircos}.
}
\examples{
data("spectra", package = "MetCirc")
MetCirc:::spectraCondition(sps = sps_tissue,
    condition = c("SPL", "LIM", "ANT", "STY"))
}
\author{
Thomas Naake \email{thomasnaake@googlemail.com}
}
