% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_bar_chart.R
\name{annotation_bar_chart}
\alias{annotation_bar_chart}
\title{Annotation bar chart}
\usage{
annotation_bar_chart(
  factor_name,
  label_rotation = FALSE,
  label_location = "inside",
  label_type = "percent",
  legend = FALSE,
  ...
)
}
\arguments{
\item{factor_name}{(character) The name of the column in the
\code{annotation_source} to generate a chart from.}

\item{label_rotation}{(logical) Rotate labels. Allowed values are
limited to the following: \itemize{ \item{\code{"TRUE"}: Rotate
labels to match segments.}\item{\code{"FALSE"}: Do not rotate
labels.}} The default is \code{FALSE}.\cr}

\item{label_location}{(character) Label location. Allowed values are
limited to the following: \itemize{ \item{\code{"inside"}: Labels are
displayed inside the bars.}\item{\code{"outside"}: Labels are
displayed outside the bars.}} The default is \code{"inside"}.}

\item{label_type}{(character) Label type. Allowed values are limited
to the following: \itemize{ \item{\code{"percent"}: Labels will
include the percentage for the segment.}\item{\code{"count"}: Labels
will include the count for the segment.}\item{\code{"none"}: Labels
will not include extra information.}} The default is
\code{"percent"}.}

\item{legend}{(logical) Display legend. Allowed values are limited to
the following: \itemize{ \item{\code{"TRUE"}: Groups are indicated
using a legend.}\item{\code{"FALSE"}: Groups are indicated in the
labels.}} The default is \code{FALSE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
annotation_bar_chart
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to
plot this chart object.
}
\description{
Display a bar chart of labels in the specified column of
an annotation_source.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{ggplot2}}}
}
\section{Inheritance}{

A \code{annotation_bar_chart} object inherits the following \code{struct}
classes: \cr\cr
\verb{[annotation_bar_chart]} -> \verb{[chart]} -> \verb{[struct_class]}
}

\examples{
M <- annotation_bar_chart(
        factor_name = "V1",
        label_location = "inside",
        label_rotation = FALSE,
        legend = FALSE,
        label_type = "percent")

}
\references{
Wickham H (2016). \emph{ggplot2: Elegant Graphics for Data
Analysis}. Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
