% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_histogram_class.R
\name{annotation_histogram}
\alias{annotation_histogram}
\title{Annotation histogram}
\usage{
annotation_histogram(
  factor_name,
  bins = 30,
  bin_edge = "grey",
  bin_fill = "lightgrey",
  vline = NULL,
  vline_colour = "red",
  ...
)
}
\arguments{
\item{factor_name}{(character) The name of the column in the
\code{annotation_source} to generate a histogram from.}

\item{bins}{(numeric, integer) The number of bins to use when
computing the histogram. The default is \code{30}.\cr}

\item{bin_edge}{(character) The colour to use when plotting the edges
of bins. The default is \code{"grey"}.}

\item{bin_fill}{(character) The colour to use when plotting the bins.
The default is \code{"lightgrey"}.}

\item{vline}{(numeric, NULL, list) The x-axis location of veritcal
lines used to indicate e.g. upper and lower limits. Use NULL if not
required. The default is \code{NULL}.}

\item{vline_colour}{(character) The colour to use when plotting
vertical lines. The default is \code{"red"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
annotation_histogram
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to
plot this chart object.
}
\description{
Display a histogram of value in the specified column of
an annotation_source.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{ggplot2}}}
}
\section{Inheritance}{

A \code{annotation_histogram} object inherits the following \code{struct}
classes: \cr\cr
\verb{[annotation_histogram]} -> \verb{[chart]} -> \verb{[struct_class]}
}

\examples{
M <- annotation_histogram(
        factor_name = "V1",
        bins = 30,
        bin_edge = "grey",
        bin_fill = "lightgrey",
        vline = NULL,
        vline_colour = "red")

}
\references{
Wickham H (2016). \emph{ggplot2: Elegant Graphics for Data
Analysis}. Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
