% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchValues.R
\name{ValueParam}
\alias{ValueParam}
\alias{MzParam}
\alias{Mass2MzParam}
\alias{Mass2MzRtParam}
\alias{MzRtParam}
\alias{Mz2MassParam}
\alias{Mz2MassRtParam}
\alias{matchValues}
\alias{matchMz}
\alias{matchValues,numeric,numeric,ValueParam-method}
\alias{matchValues,numeric,data.frameOrSimilar,ValueParam-method}
\alias{matchValues,data.frameOrSimilar,numeric,ValueParam-method}
\alias{matchValues,data.frameOrSimilar,data.frameOrSimilar,ValueParam-method}
\alias{matchValues,numeric,numeric,Mass2MzParam-method}
\alias{matchValues,numeric,data.frameOrSimilar,Mass2MzParam-method}
\alias{matchValues,data.frameOrSimilar,numeric,Mass2MzParam-method}
\alias{matchValues,data.frameOrSimilar,data.frameOrSimilar,Mass2MzParam-method}
\alias{matchValues,numeric,data.frameOrSimilar,MzParam-method}
\alias{matchValues,numeric,Spectra,MzParam-method}
\alias{matchValues,data.frameOrSimilar,numeric,MzParam-method}
\alias{matchValues,data.frameOrSimilar,data.frameOrSimilar,MzParam-method}
\alias{matchValues,data.frameOrSimilar,Spectra,MzParam-method}
\alias{matchValues,data.frameOrSimilar,data.frameOrSimilar,Mass2MzRtParam-method}
\alias{matchValues,data.frameOrSimilar,data.frameOrSimilar,MzRtParam-method}
\alias{matchValues,data.frameOrSimilar,Spectra,MzRtParam-method}
\alias{matchValues,numeric,numeric,Mz2MassParam-method}
\alias{matchValues,numeric,data.frameOrSimilar,Mz2MassParam-method}
\alias{matchValues,data.frameOrSimilar,numeric,Mz2MassParam-method}
\alias{matchValues,data.frameOrSimilar,data.frameOrSimilar,Mz2MassParam-method}
\alias{matchValues,data.frameOrSimilar,data.frameOrSimilar,Mz2MassRtParam-method}
\title{Matching of numeric values}
\usage{
ValueParam(tolerance = 0, ppm = 5)

MzParam(tolerance = 0, ppm = 5)

Mass2MzParam(adducts = c("[M+H]+"), tolerance = 0, ppm = 5)

Mass2MzRtParam(adducts = c("[M+H]+"), tolerance = 0, ppm = 5, toleranceRt = 0)

MzRtParam(tolerance = 0, ppm = 0, toleranceRt = 0)

Mz2MassParam(
  queryAdducts = c("[M+H]+"),
  targetAdducts = c("[M-H]-"),
  tolerance = 0,
  ppm = 5
)

Mz2MassRtParam(
  queryAdducts = c("[M+H]+"),
  targetAdducts = c("[M+H]+"),
  tolerance = 0,
  ppm = 5,
  toleranceRt = 0
)

matchValues(query, target, param, ...)

\S4method{matchValues}{numeric,numeric,ValueParam}(query, target, param)

\S4method{matchValues}{numeric,data.frameOrSimilar,ValueParam}(
  query,
  target,
  param,
  valueColname = character(),
  targetAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,numeric,ValueParam}(
  query,
  target,
  param,
  valueColname = character(),
  queryAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,data.frameOrSimilar,ValueParam}(
  query,
  target,
  param,
  valueColname = character(),
  queryAssay = character(),
  targetAssay = character()
)

\S4method{matchValues}{numeric,numeric,Mass2MzParam}(query, target, param)

\S4method{matchValues}{numeric,data.frameOrSimilar,Mass2MzParam}(
  query,
  target,
  param,
  massColname = "exactmass",
  targetAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,numeric,Mass2MzParam}(query, target, param, mzColname = "mz", queryAssay = character())

\S4method{matchValues}{data.frameOrSimilar,data.frameOrSimilar,Mass2MzParam}(
  query,
  target,
  param,
  mzColname = "mz",
  massColname = "exactmass",
  queryAssay = character(0),
  targetAssay = character(0)
)

\S4method{matchValues}{numeric,data.frameOrSimilar,MzParam}(query, target, param, mzColname = "mz", targetAssay = character())

\S4method{matchValues}{numeric,Spectra,MzParam}(query, target, param, mzColname = "mz", targetAssay = character())

\S4method{matchValues}{data.frameOrSimilar,numeric,MzParam}(query, target, param, mzColname = "mz", queryAssay = character())

\S4method{matchValues}{data.frameOrSimilar,data.frameOrSimilar,MzParam}(
  query,
  target,
  param,
  mzColname = c("mz", "mz"),
  queryAssay = character(),
  targetAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,Spectra,MzParam}(
  query,
  target,
  param,
  mzColname = c("mz", "mz"),
  queryAssay = character(),
  targetAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,data.frameOrSimilar,Mass2MzRtParam}(
  query,
  target,
  param,
  massColname = "exactmass",
  mzColname = "mz",
  rtColname = c("rt", "rt"),
  queryAssay = character(),
  targetAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,data.frameOrSimilar,MzRtParam}(
  query,
  target,
  param,
  mzColname = c("mz", "mz"),
  rtColname = c("rt", "rt"),
  queryAssay = character(),
  targetAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,Spectra,MzRtParam}(
  query,
  target,
  param,
  mzColname = c("mz", "mz"),
  rtColname = c("rt", "rt"),
  queryAssay = character(),
  targetAssay = character()
)

\S4method{matchValues}{numeric,numeric,Mz2MassParam}(query, target, param)

\S4method{matchValues}{numeric,data.frameOrSimilar,Mz2MassParam}(query, target, param, mzColname = "mz", targetAssay = character())

\S4method{matchValues}{data.frameOrSimilar,numeric,Mz2MassParam}(query, target, param, mzColname = "mz", queryAssay = character())

\S4method{matchValues}{data.frameOrSimilar,data.frameOrSimilar,Mz2MassParam}(
  query,
  target,
  param,
  mzColname = c("mz", "mz"),
  queryAssay = character(),
  targetAssay = character()
)

\S4method{matchValues}{data.frameOrSimilar,data.frameOrSimilar,Mz2MassRtParam}(
  query,
  target,
  param,
  mzColname = c("mz", "mz"),
  rtColname = c("rt", "rt"),
  queryAssay = character(),
  targetAssay = character()
)
}
\arguments{
\item{tolerance}{for any \code{param} object: \code{numeric(1)} defining the maximal
acceptable absolute difference in m/z (or in mass for \code{Mz2MassParam})
to consider them \emph{matching}.}

\item{ppm}{for any \code{param} object: \code{numeric(1)} defining the maximal
acceptable m/z-dependent (or mass-dependent for \code{Mz2MassParam})
difference (in parts-per-million) in m/z values to consider them to
be \emph{matching}.}

\item{adducts}{for \code{Mass2MzParam} or \code{Mass2MzRtParam}: either \code{character}
with adduct names from \code{\link[MetaboCoreUtils:adductNames]{MetaboCoreUtils::adducts()}} or \code{data.frame} with
a custom adduct definition. This parameter is used to calculate m/z from
target compounds' masses. Custom adduct definitions can be passed to the
adduct parameter in form of a \code{data.frame}. This \code{data.frame} is expected
to have columns \code{"mass_add"} and \code{"mass_multi"} defining the \emph{additive}
and \emph{multiplicative} part of the calculation. See
\code{\link[MetaboCoreUtils:adductNames]{MetaboCoreUtils::adducts()}} for the expected format or use
\code{MetaboCoreUtils::adductNames("positive")} and
\code{MetaboCoreUtils::adductNames("negative")} for valid adduct names.}

\item{toleranceRt}{for \code{Mass2MzRtParam} or \code{MzRtParam}: \code{numeric(1)}
defining the maximal acceptable absolute difference in retention time
values to consider them them \emph{matching}.}

\item{queryAdducts}{for \code{Mz2MassParam}. Adducts used to derive mass
values from query m/z values. The expected format is the same as that
for parameter \code{adducts}.}

\item{targetAdducts}{for \code{Mz2MassParam}. Adducts used to derive mass
values from target m/z values. The expected format is the same as that
for parameter \code{adducts}.}

\item{query}{feature table containing information on MS1 features. Can be
a \code{numeric}, \code{data.frame}, \code{DataFrame}, \code{matrix}, \code{SummarizedExperiment}
or \code{QFeatures}. It is expected to contain m/z values and can contain also
other variables. Matchings based on both m/z and retention time can be
performed when a column with retention times is present in both \code{query}
and \code{target}.}

\item{target}{compound table with metabolites to compare against. The
expected types are the same as those for \code{query}.}

\item{param}{parameter object defining the matching approach and containing
the settings for that approach. See description above for details.}

\item{...}{currently ignored.}

\item{valueColname}{\code{character} specifying the name of the column in
\code{query} or/and the one in \code{target}with the desired values for the
matching. This parameter should only be used when \code{param} is
\code{valueParam} and in this case it must be provided (unless both \code{query}
and \code{target} are \code{numeric}). It can be \code{character(1)} or \code{character(2)}
in a similar way to \code{mzColname}.}

\item{targetAssay}{\code{character(1)} specifying the name of the assay of the
provided \code{QFeatures} that should be used for the matching (values from
this assay's \code{rowData} will be used for matching). Only used if \code{target}
is an instance of a \code{QFeatures} object.}

\item{queryAssay}{\code{character(1)} specifying the name of the assay of the
provided \code{QFeatures} that should be used for the matching (values from
this assay's \code{rowData} will be used for matching). Only used if \code{query}
is an instance of a \code{QFeatures} object.}

\item{massColname}{\code{character(1)} with the name of the column in \code{target}
containing the mass of compounds. To be used when \code{param} is
\code{Mass2MzParam} or \code{Mass2MzRtParam} (and target is not already \code{numeric}
with the masses). Defaults to \code{massColname = "exactmass"}.}

\item{mzColname}{\code{character} specifying the name(s) of the column(s) in
\code{query} or/and \code{target}with the m/z values. If one among \code{query} and
\code{target} is \code{numeric} (and therefore there is no need to specify the
column name) or \code{query} is not \code{numeric} and \code{param} is \code{Mass2MzParam}
or \code{Mass2MzRtParam} (and therefore the name of the column with m/z needs
only to be specified for \code{query}) then \code{mzColname} is expected to be
\code{character(1)}. If both \code{query} and \code{target} are not numeric \code{mzColname}
is expected to be \code{character(2)} (or \code{character(1)} and in this last case
the two column names are assumed to be the same). If not specified the
assumed default name for columns with m/z values is \code{"mz"}. If \code{target}
is a \code{\link[Spectra:Spectra]{Spectra::Spectra()}} object, the name of the spectra variable
that should be used for the matching needs to be specified
with \code{mzColname}.}

\item{rtColname}{\code{character(2)} with the name of the column containing
the compounds retention times in \code{query} and the name for the one in
\code{target}. It can also be \code{character(1)} if the two names are the same.
To be used when \code{param} is \code{MzRtParam} or \code{Mass2MzRtParam}.
Defaults to \code{rtColname = c("rt", "rt")}. If \code{target} is a
\code{\link[Spectra:Spectra]{Spectra::Spectra()}} object, the name of the spectra variable that
should be used for the matching needs to be specified with \code{mzColname}.}
}
\value{
\link{Matched} object representing the result.

Depending on the \code{param} object different \emph{scores} representing the quality
of the match are provided. This comprises absolute as well as relative
differences (column/variables \code{"score"} and \code{"ppm_error"} respectively).
If \code{param} is a \code{Mz2MassParam}, \code{"score"} and \code{"ppm_error"} represent
differences of the compared masses (calculated from the provided m/z values).
If \code{param} an \code{MzParam}, \code{MzRtParam}, \code{Mass2MzParam} or \code{Mass2MzRtParam},
\code{"score"} and \code{"ppm_error"} represent absolute and relative differences of
m/z values.
Additionally, if \code{param} is either an \code{MzRtParam} or \code{Mass2MzRtParam}
differences between query and target retention times for each matched
element is available in the column/variable \code{"score_rt"} in the returned
\code{Matched} object.
Negative values of \code{"score"} (or \code{"score_rt"}) indicate that the m/z or mass
(or retention time) of the query element is smaller than that of the target
element.
}
\description{
The \code{matchValues} method matches elements from \code{query} with those in \code{target}
using different matching approaches depending on parameter \code{param}.
Generally, \code{query} is expected to contain MS experimental values
(m/z and possibly retention time) while \code{target} reference values. \code{query}
and \code{target} can be \code{numeric}, a two dimensional array (such as a
\code{data.frame}, \code{matrix} or \code{DataFrame}), a \code{SummarizedExperiment}
or a \code{QFeatures}, \code{target} can in addition be a \code{\link[Spectra:Spectra]{Spectra::Spectra()}} object.
For \code{SummarizedExperiment}, the information for the matching is expected
to be in the object's \code{rowData}. For \code{QFeatures} matching is performed
for values present in the \code{rowData} of one of the object's assays (which
needs to be specified with the \code{assayQuery} parameter - if a \code{QFeatures}
is used as \code{target} the name of the assay needs to be specified with
parameter \code{assayTarget}). If \code{target} is a \code{Spectra} matching is performed
against spectra variables of this object and the respective variable names
need to be specified e.g. with \code{mzColname} and/or \code{rtColname}.
\code{matchMz} is an alias for \code{matchValues} to allow backward compatibility.

Available \code{param} objects and corresponding matching approaches are:
\itemize{
\item \code{ValueParam}: generic matching between values in \code{query} and \code{target} given
acceptable differences expressed in \code{ppm} and \code{tolerance}. If \code{query} or
\code{target} are not numeric, parameter \code{valueColname} has to be used to
specify the name of the column that contains the values to be matched.
The function returns a \code{\link[=Matched]{Matched()}} object.
\item \code{MzParam}: match query m/z values against reference compounds for which
also m/z are known. Matching is performed similarly to the \code{ValueParam}
above. If \code{query} or \code{target} are not numeric, the column name containing
the values to be compared must be defined with \code{matchValues}' parameter
\code{mzColname}, which defaults to \code{"mz"}. \code{MzParam} parameters \code{tolerance}
and \code{ppm} allow to define the maximal acceptable (constant or m/z relative)
difference between query and target m/z values.
\item \code{MzRtParam}: match m/z \strong{and} retention time values between \code{query} and
\code{target}. Parameters \code{mzColname} and \code{rtColname} of the \code{matchValues}
function allow to define the columns in \code{query} and \code{target} containing
these values (defaulting to \code{c("mz", "mz")} and \code{c("rt", "rt")},
respectively). \code{MzRtParam} parameters \code{tolerance} and
\code{ppm} have the same meaning as in \code{MzParam}; \code{MzRtParam} parameter
\code{toleranceRt} allows to specify the maximal acceptable difference between
query and target retention time values.
\item \code{Mass2MzParam}: match m/z values against reference compounds for
which only the (exact) mass is known. Before matching, m/z values are
calculated from the compounds masses in the \emph{target} table using the
adducts specified via \code{Mass2MzParam} \code{adducts} parameter (defaults to
\code{adducts = "[M+H]+"}). After conversion of adduct masses to m/z values,
matching is performed similarly to \code{MzParam} (i.e. the same parameters
\code{ppm} and \code{tolerance} can be used). If \code{query} is not \code{numeric},
parameter \code{mzColname} of \code{matchValues} can be used to specify the column
containing the query's m/z values (defaults to \code{"mz"}). If \code{target} is a
is not \code{numeric}, parameter \code{massColname} can be used to define the
column containing the reference compound's masses (defaults to
\code{"exactmass"}).
\item \code{Mass2MzRtParam}: match m/z \strong{and} retention time values against
reference compounds for which the (exact) mass \strong{and} retention time are
known. Before matching, exact masses in \code{target} are converted to m/z
values as for \code{Mass2MzParam}. Matching is then performed similarly to
\code{MzRtParam}, i.e. m/z and retention times of entities are compared. With
\code{matchValues}' parameters \code{mzColname}, \code{rtColname} and \code{massColname} the
columns containing m/z values (in \code{query}), retention time values (in
\code{query} and \code{target}) and exact masses (in \code{target}) can be specified.
\item \code{Mz2MassParam}: input values for \code{query} and \code{target} are expected to be
m/z values but matching is performed on exact masses calculated from these
(based on the provided adduct definitions). In detail, m/z values in
\code{query} are first converted to masses with the \code{\link[MetaboCoreUtils:mz2mass]{MetaboCoreUtils::mz2mass()}}
function based on the adducts defined with \code{queryAdducts} (defaults to
\code{"[M+H]+"}). The same is done for m/z values in \code{target} (adducts can
be defined with \code{targetAdducts} which defaults to \verb{"[M-H-]"). Matching is then performed on these converted values similarly to }ValueParam\verb{. If }query\code{or}target\verb{are not numeric, the column containing the m/z values can be specified with}matchValues\verb{' parameter }mzColname\verb{(defaults to}"mz"`).
\item \code{Mz2MassRtParam}: same as \code{Mz2MassParam} but with additional comparison of
retention times between \code{query} and \code{target}. Parameters \code{rtColname} and
\code{mzColname} of \code{matchValues} allow to specify which columns contain the
retention times and m/z values, respectively.
}
}
\examples{

library(MetaboCoreUtils)
## Create a simple "target/reference" compound table
target_df <- data.frame(
   name = c("Tryptophan", "Leucine", "Isoleucine"),
   formula = c("C11H12N2O2", "C6H13NO2", "C6H13NO2"),
   exactmass = c(204.089878, 131.094629, 131.094629)
)

## Create a "feature" table with m/z of features. We calculate m/z for
## certain adducts of some of the compounds in the reference table.
fts <- data.frame(
    feature_id = c("FT001", "FT002", "FT003"),
    mz = c(mass2mz(204.089878, "[M+H]+"),
           mass2mz(131.094629, "[M+H]+"),
           mass2mz(204.089878, "[M+Na]+") + 1e-6))

## Define the parameters for the matching
parm <- Mass2MzParam(
    adducts = c("[M+H]+", "[M+Na]+"),
    tolerance = 0,
    ppm = 20)
res <- matchValues(fts, target_df, parm)
res

## List the available variables/columns
colnames(res)

## feature_id and mz are from the query data frame, while target_name,
## target_formula and target_exactmass are from the query object (columns
## from the target object have a prefix *target_* added to the original
## column name. Columns adduct, score and ppm_error represent the results
## of the matching: adduct the adduct/ion of the original compound for which
## the m/z matches, score the absolute difference of the query and target
## m/z and ppm_error the relative difference in m/z values.

## Get the full matching result:
matchedData(res)

## We have thus matches of FT002 to two different compounds (but with the
## same mass).

## Individual columns can also be accessed with the $ operator:
res$feature_id
res$target_name
res$ppm_error


## We repeat the matching requiring an exact match
parm <- Mass2MzParam(
    adducts = c("[M+H]+", "[M+Na]+"),
    tolerance = 0,
    ppm = 0)
res <- matchValues(fts, target_df, parm)
res

matchedData(res)

## The last feature could thus not be matched to any compound.

## At last we use also different adduct definitions.
parm <- Mass2MzParam(
    adducts = c("[M+K]+", "[M+Li]+"),
    tolerance = 0,
    ppm = 20)
res <- matchValues(fts, target_df, parm)
res

matchedData(res)

## No matches were found.

## We can also match a "feature" table with a target data.frame taking into
## account both m/z and retention time values.
target_df <- data.frame(
  name = c("Tryptophan", "Leucine", "Isoleucine"),
  formula = c("C11H12N2O2", "C6H13NO2", "C6H13NO2"),
  exactmass = c(204.089878, 131.094629, 131.094629),
  rt = c(150, 140, 140)
)

fts <- data.frame(
  feature_id = c("FT001", "FT002", "FT003"),
  mz = c(mass2mz(204.089878, "[M+H]+"),
         mass2mz(131.094629, "[M+H]+"),
         mass2mz(204.089878, "[M+Na]+") + 1e-6),
  rt = c(150, 140, 150.1)
)

## Define the parameters for the matching
parm <- Mass2MzRtParam(
  adducts = c("[M+H]+", "[M+Na]+"),
  tolerance = 0,
  ppm = 20,
  toleranceRt = 0)

res <- matchValues(fts, target_df, parm)
res

## Get the full matching result:
matchedData(res)

## FT003 could not be matched to any compound, FT002 was matched to two
## different compounds (but with the same mass).

## We repeat the matching allowing a positive tolerance for the matches
## between rt values

## Define the parameters for the matching
parm <- Mass2MzRtParam(
  adducts = c("[M+H]+", "[M+Na]+"),
  tolerance = 0,
  ppm = 20,
  toleranceRt = 0.1)

res <- matchValues(fts, target_df, parm)
res

## Get the full matching result:
matchedData(res)

## Also FT003 was matched in this case

## It is also possible to match directly m/z values
mz1 <- c(12, 343, 23, 231)
mz2 <- mz1 + rnorm(4, sd = 0.001)

res <- matchValues(mz1, mz2, MzParam(tolerance = 0.001))

matchedData(res)

## Matching with a SummarizedExperiment or a QFeatures work analogously,
## only that the matching is performed on the object's `rowData`.

## Below we create a simple SummarizedExperiment with some random assay data.
## Note that results from a data preprocessing with the `xcms` package could
## be extracted as a `SummarizedExperiment` with the `quantify` method from
## the `xcms` package.
library(SummarizedExperiment)
se <- SummarizedExperiment(
    assays = matrix(rnorm(12), nrow = 3, ncol = 4,
    dimnames = list(NULL, c("A", "B", "C", "D"))),
    rowData = fts)

## We can now perform the matching of this SummarizedExperiment against the
## target_df as before.
res <- matchValues(se, target_df,
    param = Mass2MzParam(adducts = c("[M+H]+", "[M+Na]+"),
        tolerance = 0, ppm = 20))
res

## Getting the available columns
colnames(res)

## The query columns represent the columns of the object's `rowData`
rowData(se)

## matchedData also returns the query object's rowData along with the
## matching entries in the target object.
matchedData(res)

## While `query` will return the full SummarizedExperiment.
query(res)

## To illustrate use with a QFeatures object we first create a simple
## QFeatures object with two assays, `"ions"` representing the full feature
## data.frame and `"compounds"` a subset of it.
library(QFeatures)
qf <- QFeatures(list(ions = se, compounds = se[2,]))

## We can perform the same matching as before, but need to specify which of
## the assays in the QFeatures should be used for the matching. Below we
## perform the matching using the "ions" assay.
res <- matchValues(qf, target_df, queryAssay = "ions",
    param = Mass2MzParam(adducts = c("[M+H]+", "[M+Na]+"),
        tolerance = 0, ppm = 20))
res

## colnames returns now the colnames of the `rowData` of the `"ions"` assay.
colnames(res)

matchedData(res)
}
\seealso{
\link{matchSpectra} or \code{\link[=CompareSpectraParam]{CompareSpectraParam()}} for spectra data matching
}
\author{
Andrea Vicini, Michael Witting
}
