% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_tf_target_gene.R
\name{cor_tf_target_gene}
\alias{cor_tf_target_gene}
\title{Evaluate correlation of TF expression and
target gene expression}
\usage{
cor_tf_target_gene(
  pair.tf.target,
  exp,
  tf.activity.es = NULL,
  cores = 1,
  verbose = FALSE
)
}
\arguments{
\item{pair.tf.target}{A dataframe with the following columns:
TF and target (target gene)}

\item{exp}{Gene expression matrix  or SummarizedExperiment object
(rows are genes, columns are samples) log2-normalized (log2(exp + 1)).
Samples should be in the same order as the tf.activity.es matrix}

\item{tf.activity.es}{A matrix with normalized enrichment
scores for each TF across all samples to be used in linear models instead
of TF gene expression. See \code{\link{get_tf_ES}}.}

\item{cores}{Number of CPU cores to be used. Default 1.}

\item{verbose}{Show messages ?}
}
\value{
A data frame with the following information: TF, target gene,
correlation p-value and estimate between
TF and target gene expression, FDR corrected p-values.
}
\description{
This function evaluate the correlation of a TF
and target gene expression using spearman rank correlation test.
Note that genes with RNA expression equal to 0 for all samples
will not be evaluated.
}
\examples{
exp <- t(matrix(sort(c(runif(40))), ncol = 2))
rownames(exp) <- c("ENSG00000232886","ENSG00000232889")
colnames(exp) <- paste0("Samples",1:20)

pair.tf.target <- data.frame(
   "TF" = "ENSG00000232889",
   "target" = "ENSG00000232886"
)

# Correlated TF and gene expression
results.cor.pos <- cor_tf_target_gene(
   pair.tf.target = pair.tf.target,
   exp = exp,
)
# Correlated TF and gene expression
results.cor.pos <- cor_tf_target_gene(
   pair.tf.target = pair.tf.target,
   exp = exp,
   tf.activity.es = exp
)
}
