% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichMBKEGG.R
\name{gseMBKEGG}
\alias{gseMBKEGG}
\title{Metabolism GSEA enrichment analysis for microbiome data}
\usage{
gseMBKEGG(
  metabo_list,
  nPerm = 1000,
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 101,
  maxPerm = 1e+05,
  pvalThreshold = 0.1,
  verbose = TRUE
)
}
\arguments{
\item{metabo_list}{a vector of metabolites in KEGG.ID with values}

\item{nPerm}{number of permutations.}

\item{exponent}{exponent of weighting.}

\item{minGSSize}{minimal size of genes annotated by KEGG term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing.}

\item{pvalueCutoff}{pvalue cutoff on enrichment tests to report.}

\item{pAdjustMethod}{one of "holm","hochberg","hommel","bonferroni","BH",
"BY","fdr","none".}

\item{method}{one of "multilevel", "fgsea", "bioc".}

\item{adaptive}{whether to use adaptive permutation.}

\item{minPerm}{minimal number of permutations.}

\item{maxPerm}{maximal number of permutations.}

\item{pvalThreshold}{pvalue threshold for adaptive permutation.}

\item{verbose}{whether to show progress.}
}
\value{
A \code{gseaResult} instance.
}
\description{
Metabolism GSEA enrichment analysis for microbiome data
}
