% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_rda_cca.R
\name{mp_cal_cca}
\alias{mp_cal_cca}
\alias{mp_cal_cca,MPSE-method}
\alias{mp_cal_cca,MPSE}
\alias{mp_cal_cca,tbl_mpse-method}
\alias{mp_cal_cca,tbl_mpse}
\alias{mp_cal_cca,grouped_df_mpse-method}
\alias{mp_cal_cca,grouped_df_mpse}
\title{[Partial] [Constrained] Correspondence Analysis with MPSE or tbl_mpse object}
\usage{
mp_cal_cca(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)

\S4method{mp_cal_cca}{MPSE}(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)

\S4method{mp_cal_cca}{tbl_mpse}(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)

\S4method{mp_cal_cca}{grouped_df_mpse}(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{.formula}{Model formula right hand side gives the constraining
variables, and conditioning variables can be given within a special 
function 'Condition' and keep left empty, such as ~ A + B or ~ A + Condition(B), 
default is NULL.}

\item{.dim}{integer The number of dimensions to be returned, default is 3.}

\item{action}{character "add" joins the cca result to the object, "only" return
a non-redundant tibble with the cca result. "get" return 'cca' object can
be analyzed using the related vegan funtion.}

\item{...}{additional parameters see also 'cca' of vegan.}
}
\value{
update object according action argument
}
\description{
[Partial] [Constrained] Correspondence Analysis with MPSE or tbl_mpse object
}
\examples{
library(vegan)
data(varespec, varechem)
mpse <- MPSE(assays=list(Abundance=t(varespec)), colData=varechem)
mpse
mpse \%<>\% 
    mp_cal_cca(.abundance=Abundance, 
               .formula=~Al + P*(K + Baresoil), 
               action="add")
mpse
mpse \%>\% mp_plot_ord(.ord=CCA, .group=Al, .size=K, show.sample=FALSE, bg.colour="black", colour="white")
}
\author{
Shuangbin Xu
}
