\name{recombineTwoSequences}
\alias{recombineTwoSequences}
\title{Generate new sequence from recombination of two sequences}
\usage{
recombineTwoSequences(ntSequence1, ntSequence2, preferenceVector)
}
\arguments{
\item{ntSequence1}{Character value of a nucleotide sequence}
\item{ntSequence2}{Character value of a nucleotide sequence}
\item{preferenceVector}{Numeric vector of length three which indicates which modus of recombination should be prefered. The first number states the chance of random recombination, the second number indicates the chance of cross-over recombination and the third number indicates the chance of insertion recombination.}
}
\description{
This function generates a new sequences through recombination of two parental sequences using 3 modi of recombination. Either random combination of codons, crossover recombination or insertion.
}
\value{
Character value of a nucleotide sequence, generated by recombination from the entered \code{ntSequence1} and \code{ntSequence2}. Modes of recombination are cross-over, insertion and random and mode preferences can be stated by \code{preferenceVector}.
}
\examples{
recombineTwoSequences("AGGGCCTGGAGGAGGCTT","TAAGGCAAGCCTGGACCC",c(1,3,2))

}
