% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-ModString.R
\name{ModDNAString}
\alias{ModDNAString}
\title{ModDNAString class}
\usage{
ModDNAString(x = "", start = 1, nchar = NA)
}
\arguments{
\item{x}{the input as a \code{character}.}

\item{start}{the postion in the character vector to use as start position in
the \code{ModDNAString} object (default \code{start = 1}).}

\item{nchar}{the width of the character vector to use in the 
\code{ModDNAString} object (default \code{nchar = NA}). The end position is
calculated as \code{start + nchar - 1}.}
}
\value{
a \code{ModDNAString} object
}
\description{
A \code{ModDNAString} object allows DNA sequences with modified nucleotides
to be stored and manipulated.
}
\details{
The ModDNAString class contains the virtual \code{\link{ModString}} class,
which is itself based on the \code{\link[Biostrings:XString-class]{XString}}
class. Therefore, functions for working with \code{XString} classes are 
inherited.

The \code{\link{alphabet}} of the ModDNAString class consist of the 
non-extended IUPAC codes "A,G,C,T,N", the gap letter "-", the hard masking 
letter "+", the not available letter "." and letters for individual 
modifications: \code{alphabet(ModDNAString())}.

Since the special characters are encoded differently depending on the OS and
encoding settings of the R session, it is not always possible to enter a DNA
sequence containing modified nucleotides via the R console. The most 
convinient solution for this problem is to use the function 
\code{\link{modifyNucleotides}} and modify and existing DNAString or
ModDNAString object.

A \code{ModDNAString} object can be converted into a \code{DNAString} object
using the \code{DNAstring()} constructor. Modified nucleotides are 
automaitcally converted intro their base nucleotides.

If a modified DNA nucleotide you want to work with is not part of the
alphabet, please let us know.
}
\examples{
# Constructing ModDNAString containing an m6A
md1 <- ModDNAString("AGCT`")
md1

# the alphabet of the ModDNAString class
alphabet(md1)
# due to encoding issues the shortNames can also be used
shortName(md1)
# due to encoding issues the nomenclature can also be used
nomenclature(md1) 

# convert to DNAString
d1 <- DNAString(md1)
d1
}
