% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-letterFrequency.R
\name{letterFrequency}
\alias{letterFrequency}
\alias{hasOnlyBaseLetters}
\alias{consensusString}
\alias{alphabetFrequency}
\alias{letterFrequencyInSlidingView}
\alias{hasOnlyBaseLetters,ModDNAString-method}
\alias{hasOnlyBaseLetters,ModDNAStringSet-method}
\alias{hasOnlyBaseLetters,ModRNAString-method}
\alias{hasOnlyBaseLetters,ModRNAStringSet-method}
\alias{alphabetFrequency,ModDNAString-method}
\alias{alphabetFrequency,ModRNAString-method}
\alias{alphabetFrequency,ModDNAStringSet-method}
\alias{alphabetFrequency,ModRNAStringSet-method}
\alias{alphabetFrequency,MaskedModString-method}
\alias{letterFrequency,ModStringViews-method}
\alias{letterFrequency,MaskedModString-method}
\alias{consensusMatrix,ModStringSet-method}
\alias{consensusString,ModDNAStringSet-method}
\alias{consensusString,ModRNAStringSet-method}
\alias{consensusString,ModStringViews-method}
\title{Calculate the frequency of letters in nucleotide sequence with 
modifications, or the consensus matrix of a set of sequences}
\usage{
\S4method{hasOnlyBaseLetters}{ModDNAString}(x)

\S4method{hasOnlyBaseLetters}{ModRNAString}(x)

\S4method{alphabetFrequency}{ModDNAString}(x, as.prob = FALSE, baseOnly = FALSE)

\S4method{alphabetFrequency}{ModRNAString}(x, as.prob = FALSE, baseOnly = FALSE)

\S4method{alphabetFrequency}{ModDNAStringSet}(x, as.prob = FALSE, collapse = FALSE, baseOnly = FALSE)

\S4method{alphabetFrequency}{ModRNAStringSet}(x, as.prob = FALSE, collapse = FALSE, baseOnly = FALSE)

\S4method{alphabetFrequency}{MaskedModString}(x, as.prob = FALSE, ...)

\S4method{letterFrequency}{ModStringViews}(x, letters, OR = "|", as.prob = FALSE, ...)

\S4method{letterFrequency}{MaskedModString}(x, letters, OR = "|", as.prob = FALSE)

\S4method{consensusMatrix}{ModStringSet}(x, as.prob = FALSE, shift = 0L, width = NULL, baseOnly = FALSE)

\S4method{consensusString}{ModDNAStringSet}(x, threshold = 0.25, shift = 0L, width = NULL)

\S4method{consensusString}{ModRNAStringSet}(x, threshold = 0.25, shift = 0L, width = NULL)

\S4method{consensusString}{ModStringViews}(x, threshold, shift = 0L, width = NULL)
}
\arguments{
\item{x}{a \code{\link{ModString}}, a \code{\link{ModStringSet}}, 
a \code{\link{ModStringViews}} or a \code{\link{MaskedModString}} object.}

\item{as.prob}{\code{TRUE} or \code{FALSE} (default): Should the result be 
returned as probabilities instead of counts? (\code{sum per column = 1})}

\item{baseOnly}{\code{TRUE} or \code{FALSE} (default): Should the result omit
occurances of the letters \code{N.-+}?}

\item{collapse}{\code{TRUE} or \code{FALSE} (default): Should the results 
summed up all elements for \code{ModStringSet} or \code{ModStringViews} 
objects or reported per element.}

\item{...}{See \code{\link[Biostrings]{letterFrequency}}.}

\item{letters}{See \code{\link[Biostrings]{letterFrequency}}.}

\item{OR}{See \code{\link[Biostrings]{letterFrequency}}.}

\item{shift}{See \code{\link[Biostrings]{letterFrequency}}.}

\item{width}{See \code{\link[Biostrings]{letterFrequency}}.}

\item{threshold}{Since the amiguityMap is fixed to \code{"?"} for 
\code{ModString} objects, only the treshold can be set (default 
\code{threshold = 0.25})}
}
\value{
a matrix with the results (letter x pos).
}
\description{
These functions follow the same principle as the 
\code{\link[Biostrings:letterFrequency]{Biostrings}} functions. Please be
aware, that the matices can become quite large, since the alphabet of 
\code{ModString} objects contains more letters.
}
\examples{
mod <- ModDNAString(paste(alphabet(ModDNAString()), collapse = ""))
mod
hasOnlyBaseLetters(mod)
alphabetFrequency(mod)
}
