% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotting-functions}
\alias{plotting-functions}
\alias{ggplot_me}
\alias{geom_point_me}
\alias{geom_polygon_me}
\alias{geom_raster_img}
\title{Plotting functions for SpatialUtils}
\usage{
ggplot_me()

geom_point_me(
  me,
  assayName = "detected",
  byColour = NULL,
  selectFeatures = NULL,
  ...
)

geom_polygon_me(me, assayName = "cell", byFill = NULL, ...)

geom_raster_img(
  path = NULL,
  image = NULL,
  displacement = c(0, 0),
  pixelSize = 1,
  ...
)
}
\arguments{
\item{me}{MoleculeExperiment object.}

\item{assayName}{Character string specifying name of assay from which to get
data.}

\item{byColour}{Character string specifying the column name to colour by.}

\item{selectFeatures}{character vector of features to keep for \code{geom_point_me}.}

\item{...}{Additional parameters to be passed to ggplot.}

\item{byFill}{Character string specifying the column name to fill by.}

\item{path}{Path of the image. Default: NULL}

\item{image}{Image object to be plotted as raster. Default: NULL}

\item{displacement}{the x-y coordinate of the top-left pixel of the image. Default: c(0, 0)}

\item{pixelSize}{the pixel size in micron, Default: 1}
}
\value{
A plot with transcripts and/or segmentation information for imaging
based spatial transcriptomics data.
}
\description{
A set of ggplot functions to build customized plots for imaging
based spatial transcriptomics data.
}
\examples{
repoDir <- system.file("extdata", package = "MoleculeExperiment")
repoDir <- paste0(repoDir, "/xenium_V1_FF_Mouse_Brain")
me <- readXenium(repoDir,
                  keepCols = "essential",
                  addBoundaries = c("cell", "nucleus"))

g = ggplot_me() +
        geom_polygon_me(me, byFill = "segment_id", colour = "black") +
        geom_point_me(me, byColour = "feature_id", size = 0.1) +
        geom_polygon_me(me, assayName = "nucleus", fill = NA, colour = "red")
g
}
