% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset_by_extent}
\alias{subset_by_extent}
\title{Subset functions for MoleculeExperiment objects}
\usage{
subset_by_extent(me, extent)
}
\arguments{
\item{me}{MoleculeExperiment object.}

\item{extent}{The extent in micrometers to subset the me object.
This must be of the form c(xmin, xmax, ymin, ymax).}
}
\value{
A subsetted MoleculeExperiment object
}
\description{
A set of functions to subset MoleculeExperiment objects by
different factors
}
\examples{
data(small_me)

subset_extent <- c(xmin = 3000, xman = 4000, ymin = 2000, ymax = 3000)
subset_small_me <- subset_by_extent(small_me, subset_extent)

# check the extent after subsetting
extent(subset_small_me, assayName = "detected")

}
