% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{removeNonBellShapedMotifs}
\alias{removeNonBellShapedMotifs}
\title{Remove non-bell shpape motifs prior to binding signal decomposition}
\usage{
removeNonBellShapedMotifs(motifLocations, readLocations, windowSize)
}
\arguments{
\item{motifLocations}{A vector of motif locations}

\item{readLocations}{A vector of 1nt short reads}

\item{windowSize}{Window size around binding site. The total region would be
2*windowSize+1}
}
\value{
The coordinates of accepted motifs
}
\description{
Gets motif locations and related short reads and returns the
motifs which are non-skewed abs(skewness) < 0.3 and more short reads binds
 closer to site.

It counts around motif with interval windowSize and
 windowSize/2, if the smaller window is less than half of the larger one then
  motif is not considered as Bell-shape
}
