% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_distances.R
\name{bootstrap_distances}
\alias{bootstrap_distances}
\title{Bootstrap motif-summit distances for one set of peaks and one motif}
\usage{
bootstrap_distances(
  peaks,
  motif,
  genome_build,
  samples_n = NULL,
  samples_len = NULL,
  out_dir = tempdir(),
  meme_path = NULL,
  verbose = FALSE
)
}
\arguments{
\item{peaks}{A \code{GRanges} object containing peak ranges.}

\item{motif}{A \code{universalmotif} object.}

\item{genome_build}{A \code{BSgenome} object representing the genome build.}

\item{samples_n}{An integer specifying the number of bootstrap samples to
generate. If \code{NULL}, it is set to 70\% of the number of peaks.}

\item{samples_len}{An integer specifying the number of peaks to sample in
each bootstrap iteration. If \code{NULL}, it is set to 20% of the number of
peaks.}

\item{out_dir}{Location to save the 0-order background file. By default, the
background file will be written to a temporary directory.}

\item{meme_path}{path to "meme/bin/" (default: \code{NULL}). Will use default
search behavior as described in \code{check_meme_install()} if unset.}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}
}
\value{
A \code{numeric} vector of bootstrapped mean absolute distances
between peak summits and motif positions with length equal to
\code{samples_n}.
}
\description{
This function performs bootstrapping to estimate the distribution of mean
absolute distances between peak summits and motif positions for a given set
of peaks and a specified motif.
}
\examples{
if (memes::meme_is_installed()) {
    peak <- system.file("extdata", "CTCF_ChIP_peaks.narrowPeak",
                package = "MotifPeeker") |>
                read_peak_file() |>
                sample(20)
    motif <- system.file("extdata", "motif_MA1102.3.jaspar",
                package = "MotifPeeker") |> read_motif_file()
                
    if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38")) {
        genome_build <-
            BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
            
        distances <- bootstrap_distances(
            peak = peak,
            motif = motif,
            genome_build = genome_build,
            samples_n = 2,
            samples_len = NULL,
            verbose = FALSE
        )
        print(distances)
    }
}

}
