% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_genome_build.R
\name{check_genome_build}
\alias{check_genome_build}
\title{Check genome build}
\usage{
check_genome_build(genome_build)
}
\arguments{
\item{genome_build}{A character string with the abbreviated genome build
name, or a BSGenome object. Check \link{check_genome_build} details for
genome builds which can be imported as abbreviated names.}
}
\value{
A BSGenome object.
}
\description{
Check if the genome build is valid and return an appropriate
\link[BSgenome]{BSgenome-class} object.
}
\details{
Currently, the following genome builds can be specified to
`genome_build` as abbreviated names:

\itemize{
   \item \code{hg38}: Human genome build GRCh38
   (BSgenome.Hsapiens.UCSC.hg38)
   \item \code{hg19}: Human genome build GRCh37
   (BSgenome.Hsapiens.UCSC.hg19)
   \item \code{mm10}: Mouse genome build GRCm38
   (BSgenome.Mmusculus.UCSC.mm10)
   \item \code{mm39}: Mouse genome build GRCm39
   (BSgenome.Mmusculus.UCSC.mm39)
}


If the genome build you wish to use is not listed here, please pass a
\link[BSgenome]{BSgenome-class} data object directly.
}
\examples{
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly = TRUE)) {
    check_genome_build("hg38")
}

}
\seealso{
\link[BSgenome]{BSgenome-class} for more information on BSGenome
objects.
}
