##' @title DIA benchmarking data
##'
##' @name benchmarkingDIA
##'
##' @aliases benchmarkingDIA.tsv
##'
##' @description
##'
##' These data were generated based on publicly available DIA
##' benchmarking dataset from Gotti et al. (2021). A subset of raw
##' data, containing "overlapped" in the File.Name were searched using
##' the DIA-NN software, and the resulting report.tsv (here labelled
##' as 'benchmarkingDIA.tsv') is provided.
##'
##' The dataset contains 8 conditions containing a mix of E.coli and
##' Universal Standard Protein-1 (UPS1) peptides.  Per 1 ug of E.coli
##' protein (equal in all samples), UPS1 proteins are diluted to final
##' concentration of 50, 25, 10, 5, 2.5, 1, 0.25 and 0.1 fmol.
##'
##' Each sample was prepared in 3 replicates, so altogether there are
##' 24 samples in the dataset.
##'
##' @references
##'
##' - Gotti C, Roux-Dalvai F, Joly-Beauparlant C, Mangnier L, Leclercq
##'   M, Droit A.  Extensive and Accurate Benchmarking of DIA
##'   Acquisition Methods and Software Tools Using a Complex Proteomic
##'   Standard. J Proteome Res. 2021 Oct 1;20(10):4801-4814. doi:
##'   10.1021/acs.jproteome.1c00490.  Epub 2021 Sep 2. PMID: 34472865.
##'
##' @author Kristina Gomoryova and Laurent Gatto
NULL
