% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouping-functions.R
\name{groupSimilarityMatrixTree}
\alias{groupSimilarityMatrixTree}
\title{Identifies groups with intragroup pairwise distances less than maxDiff}
\usage{
groupSimilarityMatrixTree(dists, maxDiff = 1)
}
\arguments{
\item{dists}{a \emph{distance} object such as returned by a call to \code{dist()} with
the pairwise retention time distances.}

\item{maxDiff}{\code{numeric(1)} with the maximum pairwise distance between
members of a group.}
}
\value{
\code{integers} representing groups of peaks based on retention times.
Should be of the same length as the feature definitions.
}
\description{
Searches through a complete clustering tree for branches with internal
distances less than \code{maxDiff}.
}
\details{
The search is performed top-down so that every node is evaluated for
qualifying as a group.
If the node does not qualify the algorithm iterates to the next node in the
tree. If the node qualifies, all members are added as a group to the \emph{groups
vector} and all following child nodes are skipped.
}
\seealso{
Other grouping operations: 
\code{\link{groupClosest}()},
\code{\link{groupConsecutive}()},
\code{\link{groupSimilarityMatrix}()}
}
\author{
Johan Lassen
}
\concept{grouping operations}
