% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R,
%   R/MultiDataSet-add_eset.R, R/MultiDataSet-add_genexp.R,
%   R/MultiDataSet-add_methy.R, R/MultiDataSet-add_rse.R,
%   R/MultiDataSet-add_se.R, R/MultiDataSet-add_snps.R,
%   R/MultiDataSet-add_table.R, R/MultiDataSet-as_list.R,
%   R/MultiDataSet-commonIds.R, R/MultiDataSet-commonSamples.R,
%   R/MultiDataSet-constructor.R, R/MultiDataSet-dims.R,
%   R/MultiDataSet-iclusterplus.R, R/MultiDataSet-length.R,
%   R/MultiDataSet-mcia.R, R/MultiDataSet-names.R, R/MultiDataSet-ncol.R,
%   R/MultiDataSet-nrow.R, R/MultiDataSet-rowRangesElements.R,
%   R/MultiDataSet-sampleNames.R, R/MultiDataset-assayData.R,
%   R/MultiDataset-fData.R, R/MultiDataset-pData.R, R/MultiDataset-rowRanges.R,
%   R/MultiDataset-subseting.R
\docType{class}
\name{MultiDataSet-class}
\alias{MultiDataSet-class}
\alias{add_eset,MultiDataSet,eSet-method}
\alias{MultiDataSet-methods}
\alias{add_genexp,MultiDataSet,ExpressionSet-method}
\alias{add_rnaseq,MultiDataSet,ExpressionSet-method}
\alias{add_methy,MultiDataSet,GenomicRatioSet-method}
\alias{add_rse,MultiDataSet,RangedSummarizedExperiment-method}
\alias{add_se,MultiDataSet,SummarizedExperiment-method}
\alias{add_snps,MultiDataSet,SnpSet-method}
\alias{add_table,MultiDataSet,matrix-method}
\alias{as.list,MultiDataSet-method}
\alias{as.list}
\alias{commonIds,MultiDataSet-method}
\alias{commonSamples,MultiDataSet-method}
\alias{createMultiDataSet}
\alias{dims,MultiDataSet-method}
\alias{dims}
\alias{w_iclusterplus,MultiDataSet-method}
\alias{length,MultiDataSet-method}
\alias{length}
\alias{w_mcia,MultiDataSet-method}
\alias{names,MultiDataSet-method}
\alias{MultiDataSet-methods,}
\alias{names}
\alias{ncol,MultiDataSet-method}
\alias{ncol}
\alias{nrow,MultiDataSet-method}
\alias{nrow}
\alias{rowRangesElements,MultiDataSet-method}
\alias{sampleNames,MultiDataSet-method}
\alias{assayData,MultiDataSet-method}
\alias{assayData}
\alias{fData,MultiDataSet-method}
\alias{fData}
\alias{featureData,MultiDataSet-method}
\alias{featureData}
\alias{pData,MultiDataSet-method}
\alias{pData}
\alias{phenoData,MultiDataSet-method}
\alias{phenoData}
\alias{rowRanges,MultiDataSet-method}
\alias{rowRanges}
\alias{[[,MultiDataSet,ANY,ANY-method}
\alias{[,MultiDataSet,ANY,ANY,ANY-method}
\alias{[}
\alias{subset,MultiDataSet-method}
\title{MultiDataSet instances}
\usage{
\S4method{add_eset}{MultiDataSet,eSet}(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  sample.tables = "protocolData",
  feature.tables = NULL,
  warnings = TRUE,
  overwrite = FALSE,
  GRanges
)

\S4method{add_genexp}{MultiDataSet,ExpressionSet}(object, gexpSet, ...)

\S4method{add_rnaseq}{MultiDataSet,ExpressionSet}(object, rnaSet, ...)

\S4method{add_methy}{MultiDataSet,GenomicRatioSet}(object, methySet, ...)

\S4method{add_rse}{MultiDataSet,RangedSummarizedExperiment}(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  sample.tables = NULL,
  feature.tables = "elementMetadata",
  warnings = TRUE,
  overwrite = FALSE
)

\S4method{add_se}{MultiDataSet,SummarizedExperiment}(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  sample.tables = NULL,
  feature.tables = "elementMetadata",
  warnings = TRUE,
  overwrite = FALSE,
  GRanges
)

\S4method{add_snps}{MultiDataSet,SnpSet}(object, snpSet, ...)

\S4method{add_table}{MultiDataSet,matrix}(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  warnings = TRUE,
  overwrite = FALSE
)

\S4method{as.list}{MultiDataSet}(x)

\S4method{commonIds}{MultiDataSet}(object)

\S4method{commonSamples}{MultiDataSet}(object, unify.names = FALSE)

createMultiDataSet()

\S4method{dims}{MultiDataSet}(x)

\S4method{w_iclusterplus}{MultiDataSet}(object, commonSamples = TRUE, ...)

\S4method{length}{MultiDataSet}(x)

\S4method{w_mcia}{MultiDataSet}(object, ...)

\S4method{names}{MultiDataSet}(x)

\S4method{ncol}{MultiDataSet}(x)

\S4method{nrow}{MultiDataSet}(x)

\S4method{rowRangesElements}{MultiDataSet}(object)

\S4method{sampleNames}{MultiDataSet}(object)

\S4method{assayData}{MultiDataSet}(object)

\S4method{fData}{MultiDataSet}(object)

\S4method{featureData}{MultiDataSet}(object)

\S4method{pData}{MultiDataSet}(object)

\S4method{phenoData}{MultiDataSet}(object)

\S4method{rowRanges}{MultiDataSet}(x)

\S4method{[[}{MultiDataSet,ANY,ANY}(x, i)

\S4method{[}{MultiDataSet,ANY,ANY,ANY}(x, i, j, k, ..., drop = FALSE)

\S4method{subset}{MultiDataSet}(x, feat, phe, warnings = TRUE, keep = TRUE)
}
\arguments{
\item{object}{\code{MultiDataSet}}

\item{set}{Object derived from \code{eSet} to be used to fill the slot.}

\item{dataset.type}{Character with the type of data of the omic set (e.g. expression, methylation...)}

\item{dataset.name}{Character with the specific name for this set (NULL by default). It is useful when there}

\item{sample.tables}{Character with the names of the slots with sample data besides phenoData.}

\item{feature.tables}{Character with the names of the slots with feature data besides featureData.}

\item{warnings}{Logical to indicate if warnings will be displayed.}

\item{overwrite}{Logical to indicate if the set stored in the slot will be overwritten.}

\item{GRanges}{\code{GenomicRanges} to be included in rowRanges slot.}

\item{gexpSet}{\code{ExpressionSet} to be used to fill the slot.}

\item{...}{Further arguments passed to add_rse or add_se}

\item{rnaSet}{\code{ExpressionSet} to be used to fill the slot.}

\item{methySet}{\code{GenomicRatioSet} to be used to fill the slot.}

\item{snpSet}{\code{SnpSet} to be used to fill the slot.}

\item{x}{\code{MultiDataSet}}

\item{unify.names}{Logical indicating if sample names of the sets should be unified.}

\item{commonSamples}{Logical to indicate if common samples are selected}

\item{i}{Character corresponding to selected sample names. They should match the id column of phenoData.}

\item{j}{Character with the name of the selected tables.}

\item{k}{\code{GenomicRange} used to filter the features.}

\item{drop}{If TRUE, sets with no samples or features will be discarded}

\item{feat}{Logical expression indicating features to keep}

\item{phe}{Logical expression indicating the phenotype of the samples to keep}

\item{keep}{If FALSE, sets where the expression cannot be evaluated will be discarded.}
}
\value{
\code{MultiDataSet}

\code{MultiDataSet}
}
\description{
The class \code{MultiDataSet} is a superior class to store multiple
datasets in form of triplets (assayData-phenoData-featureData). The datasets can be \code{eSet} or
\code{SummarizedExperiment} derived or \code{matrices}.
}
\details{
The names of the three lists (\code{assayData}, \code{phenoData} and
\code{featureData}) must be the same.
}
\section{Methods (by generic)}{
\itemize{
\item \code{add_eset}: Method to add an \code{eSet} to \code{MultiDataSet}.

\item \code{add_genexp}: Method to add a slot of expression to \code{MultiDataSet}.

\item \code{add_rnaseq}: Method to add a slot of (RNASeq) expression to \code{MultiDataSet}.

\item \code{add_methy}: Method to add a slot of methylation to 
\code{MultiDataSet} from a \code{GenomicRatioSet}.

\item \code{add_rse}: Method to add a \code{RangedSummarizedExperiment} to \code{MultiDataSet}.

\item \code{add_se}: Method to add a \code{SummarizedExperiment} to \code{MultiDataSet}.

\item \code{add_snps}: Method to add a slot of SNPs to \code{MultiDataSet}.

\item \code{add_table}: Method to add a \code{matrix} to \code{MultiDataSet}.

\item \code{as.list}: Returns a list with the first matrix of each
dataset.

\item \code{commonIds}: Get the name of the ids common to all datasets

\item \code{commonSamples}: Get a MultiDataSet only with the samples present in all the tables

\item \code{dims}: Returns the dimensions of the sets

\item \code{w_iclusterplus}: Apply iClusterPlus clustering method to a MultiDataSet object

\item \code{length}: Returns the number of sets into the object.

\item \code{w_mcia}: Apply mcia integration method to a MultiDataSet object

\item \code{names}: Get the names of the slots.

\item \code{ncol}: Get number of samples of each set

\item \code{nrow}: Get number of features of each set

\item \code{rowRangesElements}: Get the name of the datasets that have rowRanges

\item \code{sampleNames}: Get sample names

\item \code{assayData}: Retrieve all assay data blocks.

\item \code{fData}: Retrieve information on features.

\item \code{featureData}: Retrieve information on features.

\item \code{pData}: Retrieve information on experimental phenotypes

\item \code{phenoData}: Retrieve information on experimental phenotypes

\item \code{rowRanges}: Retrieve information on feature ranges.

\item \code{[[}: Get a set from a slot

\item \code{[}: Subset a MultiDataSet

\item \code{subset}: Filter a subset using feature ids or phenotypes
}}

\section{Slots}{

\describe{
\item{\code{assayData}}{List of \code{assayData} elements.}

\item{\code{phenoData}}{List of \code{AnnotatedDataFrame} containing the phenoData
of each \code{assayData}.}

\item{\code{featureData}}{List of \code{AnnotatedDataFrame} containing the featureData
of each \code{assayData}.}

\item{\code{rowRanges}}{List of \code{GenomicRanges} containing the rowRanges
of each \code{assayData}.}

\item{\code{extraData}}{List of other slots of the original object.}

\item{\code{return_method}}{List of functions used to create the original object.}
}}

\examples{
createMultiDataSet()
}
\seealso{
\code{\link{add_eset}}, \code{\link{add_rse}}
}
