% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEresultGroup.R
\name{DEresultGroup}
\alias{DEresultGroup}
\title{Intermediate analysis when samples belong to different
biological conditions}
\usage{
DEresultGroup(
  DESeq.result,
  LRT.supp.info = TRUE,
  pval.min = 0.05,
  log.FC.min = 1
)
}
\arguments{
\item{DESeq.result}{Output from the function
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}.}

\item{LRT.supp.info}{\code{TRUE} or \code{FALSE}.
If \code{TRUE}, the algorithm realizes another statistical test in order to
detect if, among all biological conditions and/or times, at least one has
a different behavior than the others (see the input \code{test} in
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}).}

\item{pval.min}{Numeric value between 0 and 1. A gene will be considered as
differentially expressed (DE) between two biological conditions if
its Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the threshold \code{pval.min}. Default value is 0.05.}

\item{log.FC.min}{Non negative numeric value.
If the log2 fold change between biological conditions or times has
an absolute value below the threshold \code{log.FC.min},
then the gene is not selected even if is considered as DE.
Default value is 1. If \code{log.FC.min=0}, all DE genes will be kept.}
}
\value{
The function returns the same DESeqDataSet class object
\code{DESeq.result} with the following results,
saved in the metadata \code{DEresultsGroup} of \code{DESeq.result}:
\itemize{
\item a data.frame (output \code{DEsummary} of \code{DEresultsGroup})
which contains
\itemize{
\item gene names
\item pvalues, log2 fold change and DE genes between each pairs of
biological conditions.
\item a binary column (1 and 0) where 1 means the gene is DE between at least
one pair of biological conditions.
\item \eqn{N_{bc}} binary columns, where \eqn{N_{bc}} is the number of
biological conditions, which gives the specific genes for each
biological condition.
A '1' in one of these columns means the gene is specific to the
biological condition associated to the given column. 0 otherwise.
A gene is called specific to a given biological condition BC1,
if the gene is DE between BC1 and any other biological conditions,
but not DE between any pair of other biological conditions.
\item \eqn{N_{bc}} columns filled with -1, 0 and 1, one per
biological condition.
A '1' in one of these columns means the gene is up-regulated
(or over-expressed) for the biological condition associated
to the given column.
A gene is called up-regulated for a given biological condition BC1 if
the gene is specific to the biological condition BC1 and expressions in
BC1 are higher than in the other biological conditions.
A '-1' in one of these columns means the gene is down-regulated
(or under-expressed) for the biological condition associated to the given
column.
A gene is called regulated for a given biological condition BC1 if
the gene is specific to the biological condition BC1 and expressions in
BC1 are lower than in the other biological conditions.
A '0' in one of these columns means the gene is not specific to
the biological condition associated to the given column.
}
\item a data.frame (output \code{DE.per.pair.G} of \code{DEresultsGroup})
with \eqn{N_g} rows and \eqn{((N_{bc}-1)\times N_{bc})/2} columns
with \eqn{N_g} the number of genes
and \eqn{N_{bc}} the number of biological conditions.
The number of 1 in the n-th row gives the number of pairs of
biological conditions where the gene \eqn{n} is DE.
The output \code{DE.per.pair.G} will be the input of the function
\code{\link[=DEplotVennBarplotGroup]{DEplotVennBarplotGroup()}}.
\item a contingency matrix (output \code{Contingence.per.group}
of \code{DEresultsGroup}) which gives for each biological condition
the number of genes categorized as
"Upregulated", "DownRugulated" and "Other".
A gene is categorized as 'Other', for a given biological condition BC1,
if the gene is not specific to the biological condition BC1.
The category 'Other' does not exist when there are only two
biological conditions.
}

The output \code{Contingence.per.group} will be the input of the function
\code{\link[=DEplotBarplot]{DEplotBarplot()}}.
}
\description{
This function realizes the intermediary steps of the analysis
of the function
\code{\link[=DEanalysisGroup]{DEanalysisGroup()}}.
}
\examples{
## Data
data("RawCounts_Antoszewski2022_MOUSEsub500")
## No time points. We take only two groups for the speed of the example
RawCounts_T1Wt <- RawCounts_Antoszewski2022_MOUSEsub500[seq_len(200),
                                                        seq_len(7)]

## Preprocessing step
resDATAprepSEmus1 <- DATAprepSE(RawCounts=RawCounts_T1Wt,
                                Column.gene=1,
                                Group.position=1,
                                Time.position=NULL,
                                Individual.position=2)

DESeq2preprocess <- S4Vectors::metadata(resDATAprepSEmus1)$DESeq2obj
DESeq2obj <- DESeq2preprocess$DESeq2preproceesing

##------------------------------------------------------------------------##
dds.DE.G <- DESeq2::DESeq(DESeq2obj)

res.sum.G <- DEresultGroup(DESeq.result=dds.DE.G,
                           LRT.supp.info=FALSE,
                           log.FC.min=1,
                           pval.min=0.05)
}
\seealso{
The output of the function are used by the main function
\code{\link[=DEanalysisGroup]{DEanalysisGroup()}}.
}
