% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_sumstats.R
\name{write_sumstats}
\alias{write_sumstats}
\title{Write sum stats file to disk}
\source{
\href{https://github.com/Bioconductor/VariantAnnotation/issues/35}{
VariantAnnotation::writeVcf has some unexpected/silent
file renaming behavior}
}
\usage{
write_sumstats(
  sumstats_dt,
  save_path,
  ref_genome = NULL,
  sep = "\\t",
  write_vcf = FALSE,
  save_format = NULL,
  tabix_index = FALSE,
  nThread = 1,
  return_path = FALSE,
  save_path_check = FALSE
)
}
\arguments{
\item{sumstats_dt}{data table obj of the summary statistics
file for the GWAS.}

\item{save_path}{File path to save formatted data. Defaults to
\code{tempfile(fileext=".tsv.gz")}.}

\item{ref_genome}{name of the reference genome used for the GWAS ("GRCh37" or
"GRCh38"). Argument is case-insensitive. Default is NULL which infers the
reference genome from the data.}

\item{sep}{ The separator between columns. Defaults to the character in the set \code{[,\\t |;:]} that separates the sample of rows into the most number of lines with the same number of fields. Use \code{NULL} or \code{""} to specify no separator; i.e. each line a single character column like \code{base::readLines} does.}

\item{write_vcf}{Whether to write as VCF (TRUE) or tabular file (FALSE).}

\item{save_format}{Output format of sumstats. Options are NULL - standardised
output format from MungeSumstats, LDSC - output format compatible with LDSC
and openGWAS - output compatible with openGWAS VCFs. Default is NULL.
\strong{NOTE} - If LDSC format is used, the naming convention of A1 as the
reference (genome build) allele and A2 as the effect allele will be reversed
to match LDSC (A1 will now be the effect allele). See more info on this
\href{https://groups.google.com/g/ldsc_users/c/S7FZK743w68}{here}. Note that any
effect columns (e.g. Z) will be inrelation to A1 now instead of A2.}

\item{tabix_index}{Index the formatted summary statistics with
\href{http://www.htslib.org/doc/tabix.html}{tabix} for fast querying.}

\item{nThread}{The number of threads to use. Experiment to see what works best for your data on your hardware.}

\item{return_path}{Return \code{save_path}.
This will have been modified in some cases
(e.g. after compressing and tabix-indexing a
previously un-compressed file).}

\item{save_path_check}{Ensure path name is valid (given the other arguments)
before writing (default: FALSE).}
}
\value{
If \code{return_path=TRUE}, returns \code{save_path}.
Else returns \code{NULL}.
}
\description{
Write sum stats file to disk
}
\examples{
path <- system.file("extdata", "eduAttainOkbay.txt",
    package = "MungeSumstats"
)
eduAttainOkbay <- read_sumstats(path = path)
write_sumstats(
    sumstats_dt = eduAttainOkbay,
    save_path = tempfile(fileext = ".tsv.gz")
)
}
