% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chain_file.R
\name{get_chain_file}
\alias{get_chain_file}
\title{Download chain file for liftover}
\source{
\href{https://hgdownload.cse.ucsc.edu/goldenpath/hg19/liftOver/}{
UCSC chain files}

\href{https://ftp.ensembl.org/pub/assembly_mapping/homo_sapiens/}{
Ensembl chain files}
}
\usage{
get_chain_file(
  from = c("hg38", "hg19"),
  to = c("hg19", "hg38"),
  chain_source = c("ucsc", "ensembl"),
  save_dir = tempdir(),
  verbose = TRUE
)
}
\arguments{
\item{from}{genome build converted from ("hg38", "hg19")}

\item{to}{genome build converted to ("hg19", "hg38")}

\item{chain_source}{chain file source used ("ucsc" as default, or "ensembl")}

\item{save_dir}{where is the chain file saved? Default is a temp directory}

\item{verbose}{extra messages printed? Default is TRUE}
}
\value{
loaded chain file for liftover
}
\description{
Download chain file for liftover
}
\keyword{internal}
