% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmd_proast.R
\name{bmd_proast}
\alias{bmd_proast}
\title{BMD modeling using PROAST}
\usage{
bmd_proast(
  mf_data,
  dose_col = "dose",
  response_col = "mf_min",
  covariate_col = NULL,
  bmr = 0.5,
  adjust_bmr_to_group_sd = FALSE,
  model_averaging = TRUE,
  num_bootstraps = 200,
  plot_results = FALSE,
  output_path = NULL,
  raw_results = FALSE,
  seed = 125
)
}
\arguments{
\item{mf_data}{A data frame containing the data to be analyzed. Data should
be individual for each sample. Required columns are the column containing
the dose \code{dose_col} the column(s) containing the mutation frequency
\code{response_col}, and the column containing the covariate \code{covariate_col},
if applicable.}

\item{dose_col}{The column in \code{mf_data} containing the dose data. Values
must be numeric. Default is "dose".}

\item{response_col}{The column(s) in \code{mf_data} containing the mutation
frequency. Multiple \code{response_col}s can be provided. Default is "mf_min".}

\item{covariate_col}{The column in \code{mf_data} containing the covariate.
If no covariate is present, set to \code{NULL} (default).}

\item{bmr}{The Benchmark Response value. The BMR is defined as a
bmr-percent change in mean response relative to the controls.
Default is 0.5 (50\% change).}

\item{adjust_bmr_to_group_sd}{A logical value indicating whether the group
standard deviation should be used as the BMR. If TRUE, the BMR will be
bet set to one standard deviation above the control group mean. Default is
FALSE.}

\item{model_averaging}{A logical value indicating whether confidence
intervals should be calculated using model averaging. Default is TRUE
(recommended).}

\item{num_bootstraps}{The number of bootstrap resamples to be used in the
model averaging. Default is 200 (recommended).}

\item{plot_results}{A logical value indicating whether to plot the BMD models
and/or the Cleveland plots. Default is FALSE. Plots may be exported
directly to an output_path, or returned within a list to the user.}

\item{output_path}{The file path indicating where to save the plots.
If NULL, the plots will automatically be displayed to the graphics
window and then returned as a list alongside the bmd results.}

\item{raw_results}{A logical value indicating whether to return the raw
results from the PROAST analysis. If FALSE, data is returned as a
summary table.}

\item{seed}{An integer value to set the random seed for reproducibility
when using model averaging. Default is 125. Use 0 for a random seed each
time.}
}
\value{
A summmary data frame of final results. If plots or raw results
are selected, all data will be returned within a list.

The summary will include the following for each response variable and
covariate subgroup (if applicable):
\itemize{
\item \code{Model}: The m3 or m5 model selected for each model family
(Exponential, Hill, Inverse Exponential, LogNormal).
\item \code{Response}: The response variable.
\item \code{Covariate}: The covariate subgroup, if applicable.
\item \code{bmr}: The specified Benchmark Response.
\item \code{BMD}: The Benchmark Dose, in original dose units, estimated for
the given model.
\item \code{BMDL}: The lower bound of the 90\% confidence interval for the BMD,
calculated by the profile likelihood method.
\item \code{BMDU}: The upper bound of the 90\% confidence interval for the BMD,
calculated by the profile likelihood method.
\item \code{AIC}: The Akaike Information Criterion for the selected model.
Lower values indicate a better fit. It is advised to choose the BMD value
from the model with the lowest AIC.
\item \code{weights}: The weight of the model in the model averaging process,
if applicable.
\item \verb{Model averaging}: The BMDL and BMDU calculated by the bootstrap
method if \code{model_averaging = TRUE}.
}
If there is no significant response in the data, the function will return an
empty data frame.

If \code{plot_results = TRUE} the function will create the following plots
for each response variable. The plots will be saved to the output_path.
If no output_path is provided, then they will be returned within a list
alongside the summary data frame.
\itemize{
\item Model Plots. The following plot will be created for each model
family (Exponential, Hill, Inverse Exponential, LogNormal): The fitted curve
of the selected (3 or 5) model. Data is log-transformed. Individual data
points are plotted using small triangles. The geometric mean (median) at
each dose is plotted as a large triangle. The BMD is indicated by the
dotted line. If applicable, the covariate subgroup is indicated by color.
When output_path = NULL, plots are returned alongside results as recordedPlot
objects. View plots with replayPlot().
\item bootstrap_curves If \code{model_averaging = TRUE}, the bootstrap
curves based on model averaging. The geometric mean (median) at each dose
is plotted as a large triangle. Data is log-transformed. When
output_path = NULL, plots are returned alongside results as recordedPlot
objects. View plots with replayPlot().
\item cleveland plot if \code{model_averaging = TRUE} The BMD estimate
for each model is plotted as a red point alongside the 90\% confidence
intervals. The size of the BMD point represents the model weight assigned
during model averaging, based on the AIC. When output_path = NULL, plots
are returned alongside results as ggplots. View plots by calling object
name.
}

If \code{raw_results = TRUE}, the function will return the raw results of
the PROAST analysis alongside the summary data frame. PROAST raw_results
is a list of variables and data that is continuously modified as it is
passed through the proast functions. It can be given to f.proast() to
resume analysis.
}
\description{
Calculate the benchmark dose (BMD) of continuous,
individual-level data with optional model averaging. This function
is intended to model the dose-response of mutation frequency.
This function is an extension of the PROAST software (copyright RIVM
National Institute for Public Health and the Environment).
}
\details{
This function is a  modified version of the original interactive
PROAST software (\url{https://www.rivm.nl/en/proast} that allows for batch
processing of data. The function is designed to be used with the output of
\code{calculate_mf} for the purpose of calculating the
Benchmark Dose of mutation frequency data. As such, some functionality of
the original PROAST software has been removed.

This function will accept continuous data, with an observation for each
individual subject. It is assumed that data are lognormally distributed.
The response data is log-transformed, then back-transformed after the
statistical analysis. The function will fit model 3 or 5 from various
families of models (Exponential, Hill, Inverse Exponential, LogNormal).
It will then compare the fits of models 3 and 5 for each model family and
select the model with the lowest AIC. The BMD 90\% confidence intervals will
be calculated based on the selected model (3 or 5) for each model family
using the profile likelihood method. The BMD 90\% confidence interval may
also be calculated using the bootstrap method if
\code{model_averaging = TRUE}. It is recommended to use 200 bootstraps for
model averaging.

To replicate these results in the PROAST interactive software,
select the following menu options:
\enumerate{
\item f.proast(mf_data)
\item What type of response data do you want to consider?
\emph{1: continuous, individual data}
\item Do you want to fit a single model or fit various nested families
of models? \emph{3: select model 3 or 5 from various families of models}
\item Q1: Which variable do you want to consider as the independent
variable? \emph{# : dose_col}
\item Give number(s) of the response(s) you want to analyse.
\emph{# : response_col}
\item Give number of factor serving as potential covariate (e.g.sex)
type 0 if none. \emph{# : covariate_col}
\item Do you want to adjust CES to within group SD?
\emph{1: no, 2: yes | adjust_bmr_to_group_sd: FALSE/TRUE}
\item Give value for CES (always positive) type 0 to avoid calculation
of CIs. \emph{bmr}
\item Do you want to calculate the BMD confidence interval by model
averaging? \emph{1: no 2: yes | model_averaging: FALSE/TRUE}
\item give number of bootstrap runs for calculating BMD confidence
interval based on MA (e.g. 200) \emph{num_bootstraps}
\item Which models do you want to be fitted?
\emph{4 : previous option with lognormal DR model added}
}
}
\examples{
# Example data  consists of 24 mouse bone marrow
# samples exposed to three doses of BaP alongside vehicle controls.
# Libraries were sequenced with Duplex Sequencing using
# the TwinStrand Mouse Mutagenesis Panel which consists of 20 2.4kb
# targets = 48kb of sequence. Example data can be retrieved from
# MutSeqRData, an ExperimentHub data package:
## library(ExperimentHub)
## eh <- ExperimentHub()
## query(eh, "MutSeqRData")
# Mutation frequency data was precalculated using
## mf_data_global <- calculate_mf(mutation_data = eh[["EH9861"]],
##   cols_to_group = "sample",
##   retain_metadata_cols = c("dose_group", "dose"))
mf_example <- readRDS(system.file("extdata/Example_files/mf_data_global.rds",
  package = "MutSeqR"
))
# We will calculate the BMD for a 50\% increase in mutation frequency from
# control with Model averaging.
# For the purpose of this example, num_bootstraps is set to 3 to reduce
# run time. 200 bootstraps is recommended.
bmd <- bmd_proast(
  mf_data = mf_example,
  dose_col = "dose",
  response_col = "mf_min",
  bmr = 0.5,
  model_averaging = TRUE,
  num_bootstraps = 3
)
}
