% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_helpers.R
\name{classify_variation}
\alias{classify_variation}
\title{classify_variation}
\usage{
classify_variation(ref, alt)
}
\arguments{
\item{ref}{The reference allele.}

\item{alt}{The alternate allele.}
}
\value{
A character indicating the type of variation.
}
\description{
Classify the variation type of a mutation based on its ref and
alt values.
}
\examples{
df <- data.frame(
  ref = c("A", "CAGT", "GCC", "T", "ACG", "C", "G", "T", "A"),
  alt = c("R", "TGA", "G", "TC", "TAC", "C", "<DEL>", "G", "???")
)
df$variation_type <- mapply(classify_variation, df$ref, df$alt)
df
}
