% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proast.min.R
\name{f.plot.result}
\alias{f.plot.result}
\title{Plot the PROAST results}
\usage{
f.plot.result(
  proast_results_list,
  output_path = NULL,
  output_type = "svg",
  prefix = NULL,
  model_averaging = FALSE
)
}
\arguments{
\item{proast_results_list}{The raw results list. This is the output of
\code{\link{f.proast}}}

\item{output_path}{The file path to the output directory. If the output_path
is NULL, it will save it to the working directory. If the output_path
doesn't exist, it will be created.}

\item{output_type}{The file type to export the plots. Options are 'svg',
'jpeg', 'pdf', 'png', 'tiff', or 'none'. If "none", the plots
will be displayed to the graphics window, recorded with recordPlot(), and
returned as a list.}

\item{prefix}{A custom prefix to append to the file names. Default is
"PROAST_".}

\item{model_averaging}{A logical variable indicating whether you want to
generate the model averaging figure  (TRUE) or the plots of the individual
models (FALSE). You plot one or the other, not both.  Plotting the model
averaging figure will require the function to re-run the bootstrapping so
it might take a while. You may think this seems rather inefficient. Well,
it is, but I'm too tired to fix it, so we all just have to deal with it for
now.}
}
\value{
Generates plots. Either saves them to an output path or records them
and returns them as a list.
}
\description{
Independently generate the model plots from the raw results.
}
