% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lollipop.R
\name{plot_lollipop}
\alias{plot_lollipop}
\title{Plot recurrent mutations in a lollipop plot using ggplot2}
\usage{
plot_lollipop(
  mutation_data,
  min_recurrence = 2,
  group_col = "contig",
  subtype_resolution = "base_6",
  custom_palette = NULL
)
}
\arguments{
\item{mutation_data}{A data frame containing mutation data.}

\item{min_recurrence}{An integer specifying the minimum number of times a
mutation must be observed at the same position to be plotted.
Default is 2.}

\item{group_col}{A character vector specifying the column name(s) to group
mutation_data by. Default is "contig".}

\item{subtype_resolution}{The subtype resolution by which to group and
colour the mutations. Options are "none", "type", "base_6", "base_12",
"base_96", and "base_192".}

\item{custom_palette}{A named vector of colors to be used for the mutation
subtypes. The names of the vector should correspond to the mutation subtypes
in the data. Alternatively, you can specify a color palette from the
RColorBrewer package. See \code{\link[RColorBrewer]{brewer.pal}} for palette
options. You may visualize the palettes at the ColorBrewer website:
\url{https://colorbrewer2.org/}. Default is \code{NULL}.}
}
\value{
A list of ggplot objects.
}
\description{
Plot recurrent mutations in a lollipop plot using ggplot2
}
\examples{
# For this example, we will use a subset of the example mutation data.
# The subset contains mutations from target chr1 in samples from the high
# dose group (50mg).
 example_data <- readRDS(system.file("extdata", "Example_files",
     "variants_subset_d50_chr1.rds", package = "MutSeqR"))
 # We will plot mutations that recoccur in at least two samples, grouped
 # by the "label" column, which signifies the target region (chr1).
 # Mutations will be grouped and coloured by their base 6 subtype (default) 
 plot <- plot_lollipop(
     mutation_data = example_data,
     min_recurrence = 2,
     group_col = "label"
 )
}
