% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_nice_excel.R
\name{write_excel}
\alias{write_excel}
\title{Write results to Excel tables}
\usage{
write_excel(data, output_path = NULL, workbook_name, model_results = FALSE)
}
\arguments{
\item{data}{A data frame, a list of data frames, or model_mf output.}

\item{output_path}{Directory to write to. Defaults to current working
directory.}

\item{workbook_name}{Filename (without extension).}

\item{model_results}{Logical. Set to TRUE if data is output from model_mf.}
}
\value{
A saved Excel workbook.
}
\description{
Writes data to an Excel file.
}
\examples{
# Example data consists of 24 mouse bone marrow DNA samples imported
# using import_mut_data(), filtered with filter_mut, and summarized
# using calculate_mf().
outputpath <- tempdir()
mf_example <- readRDS(system.file("extdata/Example_files/mf_data_global.rds",
  package = "MutSeqR"
))
mf_example2 <- readRDS(system.file("extdata/Example_files/mf_data_6.rds",
  package = "MutSeqR"
))
mf_example3 <- readRDS(
 system.file("extdata/Example_files/mf_data_6_sample.rds",
     package = "MutSeqR"
 )
)
list <- list(mf_example, mf_example2, mf_example3)
names(list) <- c("Global MF", "Base 6 Spectra", "Base 6 Sample Spectra")

# save a single data frame to an Excel file
write_excel(
 mf_example,
 output_path = outputpath,
 workbook_name = "test_single"
)

# save a list of data frames to an Excel file
write_excel(list, output_path = outputpath, workbook_name = "test_list")
}
