% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_sigprofiler_input.R
\name{write_mutational_matrix}
\alias{write_mutational_matrix}
\title{Write a Mutational Matrix to input into the sigprofiler web application}
\usage{
write_mutational_matrix(
  mutation_data,
  group = "dose",
  subtype_resolution = "base_96",
  mf_type = "min",
  output_path = NULL
)
}
\arguments{
\item{mutation_data}{The object containing the mutation data.
The output of import_mut_data() or import_vcf_data().}

\item{group}{The column in the mutation data used to aggregate groups
(e.g., sample, tissue, dose).}

\item{subtype_resolution}{The resolution of the mutation subtypes. Options
are "base_6" or "base_96". Default is "base_96".}

\item{mf_type}{The mutation counting method to use. Options are "min" or
"max". Default is "min".}

\item{output_path}{The path to save the output file. If not provided, the
file will be saved in the current working directory. Default is NULL.}
}
\value{
a .txt file that can be uploaded to the SigProfiler Assignment web
application (https://cancer.sanger.ac.uk/signatures/assignment/) as
a "Mutational Matrix".
}
\description{
Creates a .txt file from mutation data that can be used for mutational
signatures analysis using the SigProfiler web application. Can handle
group analyses (ex dose, tissue, etc). Currently only supports SBS matrices
i.e. snvs.
}
\details{
Mutations will be be filtered for SNVs. Mutations flagged in
\code{filter_mut} will be excluded from the output. Mutations will be summed
across the groups specified in the \code{group} argument.
}
\examples{
# Example data  consists of 24 mouse bone marrow
# samples exposed to three doses of BaP alongside vehicle controls.
# Libraries were sequenced with Duplex Sequencing using
# the TwinStrand Mouse Mutagenesis Panel which consists of 20 2.4kb
# targets = 48kb of sequence. Example data can be retrieved from
# MutSeqRData, an ExperimentHub data package:
## library(ExperimentHub)
## eh <- ExperimentHub()
## query(eh, "MutSeqRData")
# The data is a subset of variants from the target chr1
# from samples of the high dose group (50mg).
example_data <- readRDS(system.file("extdata", "Example_files",
                                    "variants_subset_d50_chr1.rds",
                                     package = "MutSeqR")
)

  write_mutational_matrix(
    mutation_data = example_data,
    group = "sample",
    subtype_resolution = "base_96",
    mf_type = "min",
    output_path = tempdir()
  )
  list.files(tempdir())
  # The file is saved in the temporary directory
  # To view the file, use the following code:
  ## output_file <- file.path(tempdir(), "sample_base_96_mutational_matrix.txt")
  ## file.show(output_file)
}
