% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_grange.R
\name{plot_grange_heatmap}
\alias{plot_grange_heatmap}
\title{Plot GRanges heatmap}
\usage{
plot_grange_heatmap(
  x,
  grange,
  pos_style = c("to_scale", "compact"),
  window_prop = 0,
  subsample = 50
)
}
\arguments{
\item{x}{the NanoMethResult object.}

\item{grange}{the GRanges object with one entry.}

\item{pos_style}{the style for plotting the base positions along the x-axis.
Defaults to "to_scale", plotting (potentially) overlapping squares
along the genomic position to scale. The "compact" options plots only the
positions with measured modification.}

\item{window_prop}{the size of flanking region to plot. Can be a vector of two
values for left and right window size. Values indicate proportion of region
length.}

\item{subsample}{the number of read of packed read rows to subsample to.}
}
\value{
a ggplot plot containing the heatmap.
}
\description{
Plot GRanges heatmap
}
\examples{
nmr <- load_example_nanomethresult()
plot_grange_heatmap(nmr, GenomicRanges::GRanges("chr7:6703892-6730431"))

}
